float4x4 matWorldViewProjection;
float4x4 matWorldView;

float4x4 matProjection; 

float3 camera; 
float alphavalue = 1.f;

texture tex0; //cube
texture tex1; //2d
texture tex2; //22d

samplerCUBE diffuse = 
sampler_state 
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressU = Wrap;
};

sampler2D diffuse2 = 
sampler_state 
{
	texture = (tex1);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressU = Wrap;
};

sampler2D diffuse3 = 
sampler_state 
{
	texture = (tex2);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressU = Wrap;
};

void vs_blob(in float4 ipos : POSITION,
			 in float3 inormal : NORMAL,
			 in float2 itex : TEXCOORD0,
			 out float4 opos : POSITION,
			 out float2 otex : TEXCOORD0,
			 out float3 onormal : TEXCOORD1)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
	onormal = mul(inormal, matWorldView);
};

float4 ps_blob(in float2 tex : TEXCOORD0,
			   in float3 normal : TEXCOORD1) : COLOR0
{
	//return texCUBE(diffuse, normal);
	
	float3 f = reflect(normal, normalize(camera))+.5f;
	f = cross( normalize(camera), normal);
	f = normal;
	return float4(f, 0.f); 
	//return float4(normal.xyz, dot(normalize(camera), normal)); 
};

/*******************************************************************/

void vs_on(in float4 ipos : POSITION,
		   in float2 itex : TEXCOORD0,
		   out float4 opos : POSITION,
		   out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matProjection);
	otex = itex;
	otex.y += 1.f;
}

float4 ps_on(in float2 tex : TEXCOORD0) : COLOR0
{

	float4 read = tex2D(diffuse2, tex);
	

	
	float2 texcoord = read.xy;
	texcoord.y = 1.f- texcoord.y;
	texcoord.x = sin(1.f- texcoord.x);
	float4 pixel = tex2D(diffuse3, texcoord);
	
	pixel = dot(read.xyz, normalize(camera));
	
	pixel *= tex2D(diffuse3, pixel);
	// pixel = texCUBE(diffuse, pixel);
	
	if(read.a==1.f)
		return float4(0.f, 0.f, 0.f, 0.f);
	else 
		return float4(pixel.rgb, 1.f*alphavalue);
//	return float4(, 0.f, 1.f);
}

technique blob
{
	pass normal
	{
		VertexShader = compile vs_2_0 vs_blob();
		PixelShader  = compile ps_2_0 ps_blob();
	}
	
	pass post
	{
		VertexShader = compile vs_2_0 vs_on();
		PixelShader  = compile ps_2_0 ps_on();
	}
}