float4x4 matWorldViewProjection;

texture tex0;

sampler2D diffuse = 
sampler_state
{
	texture = (tex0);
	MipFilter = None; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

void vs_main(in float4 ipos : POSITION,
			 in float2 itex : TEXCOORD0,
			 out float4 opos : POSITION,
			 out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex; 
}

float4 ps_main(in float2 tex : TEXCOORD0) : COLOR0
{
	return tex2D(diffuse, tex);
	//return float4(1.f, 1.f, 1.f, 1.f);
}

float4 ps_black(in float2 tex : TEXCOORD0) : COLOR0
{
	float4 p = tex2D(diffuse, tex);
	
	if(p.r == 0.f)
		return float4(1.f, 1.f, 1.f, 1.f);
	else
		return float4(0.f, 0.f, 0.f, 0.f);
}

technique Line
{
	pass White
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_main();
	}
	
	pass Black
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_black();
	}
}