float4x4 matProjection;

float2 ps = {1.f/400.f, 1.f/300.f}; 
float blur = 1.8f;
float alpha = 1.f; //pass1

texture tex0;
sampler2D blurtexture = 
sampler_state 
{
	texture = (tex0);
	MipFilter = None; MinFilter = Linear; MagFilter = Linear; 
	AddressU = Clamp; AddressV = Clamp;
};

void vs_blur(in float4 ipos : POSITION,
			 in float2 itex : TEXCOORD0,
			 out float4 opos : POSITION,
			 out float2 otex : TEXCOORD0) 
{
	opos = mul(ipos, matProjection);
	otex = itex;
	otex.y += 1.f;
}

float4 ps_blur(in float2 tex : TEXCOORD0) : COLOR0
{
	ps *= blur;
	float4 accum = tex2D(blurtexture, float2(tex.x, tex.y)) + 
				   tex2D(blurtexture, float2(tex.x+ps.x, tex.y)) +
				   tex2D(blurtexture, float2(tex.x-ps.x, tex.y)) +
				   tex2D(blurtexture, float2(tex.x, tex.y+ps.y)) +
				   tex2D(blurtexture, float2(tex.x, tex.y-ps.y)) +
				   tex2D(blurtexture, float2(tex.x+ps.x, tex.y+ps.y)) +
				   tex2D(blurtexture, float2(tex.x-ps.x, tex.y-ps.y)) +
				   tex2D(blurtexture, float2(tex.x-ps.x, tex.y+ps.y)) +
				   tex2D(blurtexture, float2(tex.x+ps.x, tex.y-ps.y));
	return accum/9.f;
}

float4 ps_glow(in float2 tex : TEXCOORD0) : COLOR0
{
	ps *= blur;
	float4 accum = tex2D(blurtexture, float2(tex.x, tex.y)) + 
				   tex2D(blurtexture, float2(tex.x+ps.x, tex.y)) +
				   tex2D(blurtexture, float2(tex.x-ps.x, tex.y)) +
				   tex2D(blurtexture, float2(tex.x, tex.y+ps.y)) +
				   tex2D(blurtexture, float2(tex.x, tex.y-ps.y)) +
				   tex2D(blurtexture, float2(tex.x+ps.x, tex.y+ps.y)) +
				   tex2D(blurtexture, float2(tex.x-ps.x, tex.y-ps.y)) +
				   tex2D(blurtexture, float2(tex.x-ps.x, tex.y+ps.y)) +
				   tex2D(blurtexture, float2(tex.x+ps.x, tex.y-ps.y));
	float4 pixel =  (accum/9.f);
	return (pixel*pixel)*alpha;
}


technique Blur
{
	pass Simple
	{
		VertexShader = compile vs_2_0 vs_blur();
		PixelShader  = compile ps_2_0 ps_blur(); 
	}
	
	pass Glow
	{
		VertexShader = compile vs_2_0 vs_blur();
		PixelShader  = compile ps_2_0 ps_glow(); 
	}
}