/*
Copyright 2007 John Tsiombikas <nuclear@siggraph.org>

This file is part of the pixelshow 2007 invitation demo.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with the program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef TEXT_H
#define TEXT_H

#include "vec.h"

typedef struct color {
	float r, g, b, a;
} color_t;

unsigned int create_font(const char *fname, int font_size);
void delete_font(unsigned int fid);
unsigned int get_font(const char *fname, int sz);
int bind_font(unsigned int fid);

void set_text_pos(float x, float y);
vec2_t get_text_pos(void);

void text_line_advance(int adv);
void text_cret(void);

void set_text_size(float sz);
float get_text_size(void);

void set_text_color(float r, float g, float b, float a);
color_t get_text_color(void);

float print_string(const char *text);
void print_string_lines(const char **str, int lines);

float get_max_descent(void);
float get_line_advance(void);
float get_text_width(const char *str);

#endif	/* TEXT_H */
