/*
Copyright 2007 John Tsiombikas <nuclear@siggraph.org>

This file is part of the pixelshow 2007 invitation demo.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with the program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _MESH_H_
#define _MESH_H_

#include "vec.h"

struct vertex {
	vec3_t pos;
	vec3_t norm;
	vec3_t texc;
};

struct mesh {
	struct vertex *varr;
	int vnum;

	void *kdtree;
};

struct mesh *create_mesh(struct vertex *varr, int vnum);
void free_mesh(struct mesh *m);
void make_kdtree(struct mesh *m);

void calc_normals(struct mesh *mesh);

void draw_mesh(struct mesh *m);

#endif	/* _MESH_H_ */
