/*
Copyright 2007 John Tsiombikas <nuclear@siggraph.org>

This file is part of the pixelshow 2007 invitation demo.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with the program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _KDTREE_H_
#define _KDTREE_H_

#ifdef __cplusplus
extern "C" {
#endif

void *kd_create(void);
void kd_free(void *tree);

/* remove all the elements from the tree */
void kd_clear(void *tree);

/* if called with non-null 2nd argument, the function provided
 * will be called on data pointers (see kd_insert) when nodes
 * are to be removed from the tree.
 */
void kd_data_destructor(void *tree, void (*destr)(void*));

/* insert a node, specifying its 3D position, and optional data */
int kd_insert(void *tree, float x, float y, float z, void *data);

/* Find the N nearest nodes from the specified point.
 *
 * This function returns a pointer to a result set, which can be manipulated
 * by the kd_res_* functions.
 * The returned pointer can be null as an indication of an error. Otherwise
 * a valid result set is always returned which may contain 0 or more elements.
 */
/*void *kd_nearest_n(void *tree, float x, float y, float z, int num);*/

/* Find any nearest nodes from the specified point within a range.
 *
 * This function returns a pointer to a result set, which can be manipulated
 * by the kd_res_* functions.
 * The returned pointer can be null as an indication of an error. Otherwise
 * a valid result set is always returned which may contain 0 or more elements.
 */
void *kd_nearest_range(void *tree, float x, float y, float z, float range);

/* frees a result set returned by kd_nearest_range() */
void kd_res_free(void *set);

/* returns the size of the result set (in elements) */
int kd_res_size(void *set);

/* rewinds the result set iterator */
void kd_res_rewind(void *set);

/* returns non-zero if the set iterator reached the end after the last element */
int kd_res_end(void *set);

/* advances the result set iterator, returns non-zero on success, zero if
 * there are no more elements in the result set.
 */
int kd_res_next(void *set);

/* returns the data pointer (can be null) of the current result set item
 * and optionally sets its position to the x, y, z pointers, if not null.
 */
void *kd_res_item(void *set, float *x, float *y, float *z);

/* equivalent to kd_res_item(set, 0, 0, 0) */
void *kd_res_item_data(void *set);


#ifdef __cplusplus
}
#endif

#endif	/* _KDTREE_H_ */
