/*
This file is part of a small image library.
Copyright (C) 2004 - 2006 John Tsiombikas <nuclear@siggraph.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/* image file handling library */
#ifndef IMAGE_H_
#define IMAGE_H_

/* always compile support for image formats that
 * don't create any library dependencies.
 */
#define IMGLIB_USE_PPM
#define IMGLIB_USE_TGA

/* for jpeg and png, make the default be to compile them in,
 * unless explicitly disabled.
 */
#ifndef IMGLIB_NO_JPEG
#define IMGLIB_USE_JPEG
#endif	/* IMGLIB_NO_JPEG */

#ifndef IMGLIB_NO_PNG
#define IMGLIB_USE_PNG
#endif	/* IMGLIB_NO_PNG */

/* supported image file formats */
enum image_file_format {
	IMG_FMT_PNG,	/* PNG compressed, 32/24bit (libpng/zlib) */
	IMG_FMT_JPEG,	/* JPEG compressed (lossy), 24bit (ijg libjpeg) */
	IMG_FMT_TGA,	/* Targa uncompressed/rle 32/24bit */
	IMG_FMT_PPM		/* Portable PixMap uncompressed 24bit binary/text */
};

/* various save options */
enum {
	IMG_SAVE_ALPHA		= 1,	/* if the format allows 32bit images with alpha */
	IMG_SAVE_COMPRESS	= 2,	/* if the format supports both un/compressed */
	IMG_SAVE_INVERT		= 4,	/* invert scanlines (top-bottom) */
	IMG_SAVE_TEXT		= 8		/* if the format supports text-based output */
};

#ifdef __cplusplus
extern "C" {
#endif	/* __cplusplus */

/* load_image() loads the specified image from file, returns the pixel data
 * in 32bit mode, and changes xsz and ysz to the size of the image
 */
void *load_image(const char *fname, int *xsz, int *ysz);

/* deallocate the image data with this function
 * note: provided for consistency, simply calls free()
 */
void free_image(void *img);

/* save the supplied image data in a file of the specified format */
int save_image(const char *fname, void *pixels, int xsz, int ysz, enum image_file_format fmt);

/* set/get save image options */
void set_image_save_flags(unsigned int flags);
unsigned int get_image_save_flags(void);

#ifdef __cplusplus
}
#endif	/* __cplusplus */
	
#endif	/* IMAGE_H_ */
