/*
Copyright 2007 John Tsiombikas <nuclear@siggraph.org>

This file is part of the pixelshow 2007 invitation demo.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with the program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <GL/glew.h>
#include "bdrop.h"
#include "image.h"

void startup_text(const char *txt);

static unsigned int tex;

int init_backdrop(void)
{
	void *img;
	int xsz, ysz;

	startup_text("loading backdrop...");
	if(!(img = load_image("data/bdrop.ppm", &xsz, &ysz))) {
		startup_text("... failed");
		return -1;
	}

	glGenTextures(1, &tex);
	glBindTexture(GL_TEXTURE_1D, tex);
	glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexImage1D(GL_TEXTURE_1D, 0, 4, xsz, 0, GL_BGRA, GL_UNSIGNED_BYTE, img);

	free_image(img);

	return 0;
}

void draw_backdrop(unsigned int msec)
{
	const float center = 0.5;

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();

	glEnable(GL_TEXTURE_1D);
	glBindTexture(GL_TEXTURE_1D, tex);

	glBegin(GL_QUADS);
	glColor3f(1, 1, 1);
	
	glTexCoord1f(1);
	glVertex2f(-1, -1);
	glVertex2f(1, -1);

	glTexCoord1f(0);
	glVertex2f(1, center);
	glVertex2f(-1, center);

	glVertex2f(-1, center);
	glVertex2f(1, center);
	
	glTexCoord1f(0.5);
	glVertex2f(1, 1);
	glVertex2f(-1, 1);
	glEnd();

	glDisable(GL_TEXTURE_1D);

	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
}
