/*
Copyright 2007 John Tsiombikas <nuclear@siggraph.org>

This file is part of the pixelshow 2007 invitation demo.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with the program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <math.h>
#include <GL/glew.h>
#include "bar.h"
#include "image.h"
#include "sdr.h"

#define MIN(a, b)	((a) < (b) ? (a) : (b))

void startup_text(const char *txt);

static unsigned int logo_tex;
static unsigned int prog;

int init_bar(void)
{
	void *pixels;
	int xsz, ysz;

	if(!(pixels = load_image("data/pixelshow_logo.png", &xsz, &ysz))) {
		return -1;
	}
	glGenTextures(1, &logo_tex);
	glBindTexture(GL_TEXTURE_2D, logo_tex);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0, 4, xsz, ysz, 0, GL_BGRA, GL_UNSIGNED_BYTE, pixels);
	free_image(pixels);
	if(glGetError() != GL_NO_ERROR) {
		return -1;
	}

	startup_text("loading bar shaders...");
	if(!(prog = create_program_load("sdr/bar.v.glsl", "sdr/bar.p.glsl"))) {
		startup_text("... failed");
		return -1;
	}

	return 0;
}

void draw_bar(unsigned int msec)
{
	float t = (float)msec / 1000.0;
	float max_x = 0.25;
	float xpos = cos(MIN(t / 2.0, 1.5708)) * 1.1;

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();

	glTranslatef(-xpos, 0, 0);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	bind_program(prog);
	set_uniform_float(prog, "t", t * 1.1);

	glBegin(GL_QUADS);
	glColor4f(0.99, 0.94, 0.0, 0.6);
	glTexCoord2f(0, 0); glVertex2f(-1, -1);
	glTexCoord2f(1, 0); glVertex2f(max_x, -1);
	glTexCoord2f(1, 1.2); glVertex2f(max_x, 1);
	glTexCoord2f(0, 1.2); glVertex2f(-1, 1);
	glEnd();

	set_uniform_float(prog, "t", t - 2.0);
	
	glPushMatrix();
	glTranslatef(-0.1, 0, 0);

	glBegin(GL_QUADS);
	glColor3f(0.93, 0.08, 0.36);
	glTexCoord2f(0, 0); glVertex2f(-1, -1);
	glTexCoord2f(1, 0); glVertex2f(max_x, -1);
	glTexCoord2f(1, 1); glVertex2f(max_x, 1);
	glTexCoord2f(0, 1); glVertex2f(-1, 1);
	glEnd();
	
	glPopMatrix();

	bind_program(0);

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, logo_tex);

	glTranslatef(-1, 0.25, 0);
	glScalef(0.75, 0.75, 0);

	glBegin(GL_QUADS);
	glColor3f(1, 1, 1);
	glTexCoord2f(0, 1); glVertex2f(0, 0);
	glTexCoord2f(1, 1); glVertex2f(1, 0);
	glTexCoord2f(1, 0); glVertex2f(1, 1);
	glTexCoord2f(0, 0); glVertex2f(0, 1);
	glEnd();

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);

	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
}
