uniform sampler2D tex;
varying vec3 normal, vcs_pos, vcs_lpos;

void main()
{
	vec3 l = normalize(vcs_lpos - vcs_pos);
	vec3 n = normalize(normal);
	vec3 v = -normalize(vcs_pos);
	vec3 h = normalize(l + v);

	float d = max(dot(n, l), 0.0);
	float s = pow(max(dot(n, h), 0.0), gl_FrontMaterial.shininess);

	vec3 dcol = gl_FrontMaterial.diffuse.rgb * texture2D(tex, vec2(d, 0.55)).rgb;
	vec3 scol = gl_FrontMaterial.specular.rgb * texture2D(tex, vec2(s, 1.0)).rgb;

	gl_FragColor = vec4(dcol, 1.0) + vec4(scol, 1.0);
}
