uniform sampler2D baseMap;

varying vec3 Normal;
varying vec3 LightDirection;
varying vec3 Positon;
varying vec2 Texcoord;

uniform float fader;

void main( void )
{
	const float MaxHeight = 25.0;
	const float TransWidth = 0.1;
	float alpha = smoothstep( fader-TransWidth, fader+TransWidth, Positon.y/MaxHeight );
	vec4 fvDiffuse        = vec4( texture2D( baseMap, Texcoord ).xyz*alpha, 1.0 );
	vec3 fvNormal         = normalize( Normal );
	vec3 fvLightDirection = normalize( LightDirection );

	gl_FragColor = ( dot( fvNormal, fvLightDirection )*fvDiffuse );
//	gl_FragColor = dot( fvNormal, fvLightDirection )*vec4( 0.2, 0.4, 0.8, 1.0 );
}

