;
; Digi 64 - A digiplayer in only 64 bytes
;
; Written by Csabo of LOD in 2007
; 

ptr	= $31		; will point to $10##
count	= $EE		; assumed to start from value $FF
wait	= $EF       	; any zeropage variable

 	ORG $100D-2
	DW $100D
	
	SEI			; must disable interrupts
	LSR $FF06		; turn screen off
	;
restart	INC count		; increase pattern counter
	LDA count
	AND #$0F		; 16 bytes for the pattern
	TAY
	LDA beat,y
	STA ptr			; load data position for current
	;
main	TXA			; 
	LSR A			; div 4: make bass (and all other samples) deeper
	LSR A
	AND #$03		; limit to 4 bytes per sample :-)
	TAY			; 
	LDA (ptr),y		; load the sample
	STA $FF11		; put it out to volume - plays the digi
	STA $FF19		; put it to border - looks cool :-)
	;
	STX wait		; the delay stars from X, inexact, but works
	;
delay	DEC wait		; the delay loop
	BNE delay
	;
	INX			; change to dex for "backwards" samples :-)
	BNE main
	;
	BEQ restart		; always jump

	;
	; Waveforms, 4 bytes each
	;
	; some these are just pointing to "random" places in the code
	; but they do sound okay
	;
bass	DB $90,$90,$B8,$B8	; strong bass like punch
snare	DB $B1,$37,$B1		; strong noisy punch

noise1	= $1011			; louder noise (echo)
noise2	= $101A			; quiet noise (hihat/pause)
snare2	= $102B			; clean punch


b0	= bass & 255
n1	= noise1 & 255
n2	= noise2 & 255
s1	= snare & 255
s2	= snare2 & 255
	;
	; The beat
	; Luxurious 16 bytes of music!
	; Uncomment the other ones and feel free to experiment
	;
beat	
	DB b0,n2,n1,b0,s1,n2,n1,b0	; laid back beat
	DB n2,b0,b0,n2,s1,n2,n1,s2
		
	;DB b0,n2,s1,b0,n2,n2,s1,n1	; another one
	;DB n2,b0,s1,n1,b0,b0,s1,n1
	
	;DB b0,b0,s1,b0,n1,b0,s1,n1	; a faster beat
	;DB b0,b0,s1,b0,n1,b0,s1,s2
	
	;DB b0,n1,b0,n2,b0,n1,b0,n1	; hardcore techno
	;DB b0,n1,b0,n2,b0,b0,b0,s2
;[eof]