shared float4x4 mWorld;
shared float4x4 mView;
shared float4x4 mProj;
shared float4x4 mWorldView;
shared float4x4 mWorldViewProj;
shared float4x4 mViewProj;
shared float4x4 mFrustum;
shared float4x4 mWorldFrustum;

shared float4x4 mBias;
shared float4x4 mViewProjBias;
shared float4x4 mProjBias;
shared float4x4 mInvView;
shared float4x4 mInvProj;

shared float4x4 mShadowViewProjBias;

shared float4 vPointLightPos;
shared float4 vPointLightColour;
shared float4 vAmbientColour;

shared float4 vRandomTaps[4];
shared float4 vEyePos;

shared float4 vConstColour;
shared float4 vUVTransform;

shared texture tShadowTexture;
sampler sShadowSampler = 
sampler_state
{
    Texture = <tShadowTexture>;
    MipFilter = POINT;
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

shared texture tShadowJitterTexture;
sampler sShadowJitterSampler = 
sampler_state
{
    Texture = <tShadowJitterTexture>;
    MipFilter = POINT;
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

float CalculateShadow(in float4 inShadowPosition, in float4 inShadowJitterPosition)
{
	float4 vShadowJitter=tex2Dproj(sShadowJitterSampler, inShadowJitterPosition)*2.0f-1.0f;
	float fShadow=0;
	for (int i=0;i<4;i++)
	{
		float4 vJitteredTap=reflect(vRandomTaps[i], vShadowJitter);
		float fShadowDepth=tex2Dproj(sShadowSampler, inShadowPosition+inShadowPosition.w*vJitteredTap).r;
		fShadow+=fShadowDepth>=inShadowPosition.z ? 1.0f/4.0f : 0.0f;
	}
	return fShadow;
}
