#include "sharedfx.h"

void SimpleVS(	float4 inPosition : POSITION,
					float4 inNormal : NORMAL,
					
					out float4 outPosition : POSITION,
					out	float3 outNormal : TEXCOORD0
 )
{
	outPosition = mul(inPosition, mWorldViewProj);
	outNormal = mul(inNormal, (float3x3)mWorldView);
}

float4 SimplePS( float3 inNormal : TEXCOORD0 ) : COLOR
{
	return float4(inNormal*0.5f+0.5f, 1.0f);
}

void ShadowMapVS(	float4 inPosition : POSITION,
					out float4 outPosition : POSITION,
					out float outDepth : TEXCOORD0
 )
{
	outPosition = mul(inPosition, mWorldViewProj);
	outDepth = outPosition.z;
}

float4 ShadowMapPS( float inDepth : TEXCOORD0 ) : COLOR
{
	return inDepth;
}

technique Simple
{
    pass P0
    {          
        VertexShader = compile vs_2_0 SimpleVS();
        PixelShader  = compile ps_2_0 SimplePS();
		ZEnable = TRUE;
		ZWriteEnable = TRUE;
		ZFunc = LESSEQUAL;
		AlphaBlendEnable = FALSE;
		AlphaTestEnable = FALSE;
    }
}

technique ShadowMap
{
    pass P0
    {          
        VertexShader = compile vs_2_0 ShadowMapVS();
        PixelShader  = compile ps_2_0 ShadowMapPS();
		ZEnable = TRUE;
		ZWriteEnable = TRUE;
		ZFunc = LESSEQUAL;
		AlphaBlendEnable = FALSE;
		AlphaTestEnable = FALSE;
    }
}

void DepthVS(	float4 inPosition : POSITION,
					float3 inNormal : NORMAL,
					out float4 outPosition : POSITION,
					out float outDepth : TEXCOORD0
 )
{
	outPosition = mul(inPosition, mWorldViewProj);
	outDepth = mul(inPosition, mWorldView).z;
}

float4 DepthPS(			float	inDepth : TEXCOORD0 ): COLOR
{
	return inDepth;
}

technique Depth
{
    pass P0
    {          
        VertexShader = compile vs_2_0 DepthVS();
        PixelShader  = compile ps_2_0 DepthPS();
		ZEnable = TRUE;
		ZWriteEnable = TRUE;
		ZFunc = LESSEQUAL;
		AlphaBlendEnable = FALSE;
		AlphaTestEnable = FALSE;
    }
}

void ShadowedVS(	float4 inPosition : POSITION,
					float4 inNormal : NORMAL,
					
					out float4 outPosition : POSITION,
					out float4 outShadowPosition : TEXCOORD0,
					out float4 outShadowJitterPosition : TEXCOORD1,
					out	float3 outNormal : TEXCOORD2,
					out float3 outToLight : TEXCOORD3
 )
{
	float4 worldPosition = mul(inPosition, mWorld);
	outPosition = mul(worldPosition, mViewProj);
	outShadowPosition = mul(worldPosition, mShadowViewProjBias);
	outNormal.xyz = mul(inNormal, (float3x3)mWorld);
	outToLight = vPointLightPos - worldPosition.xyz;
	outShadowJitterPosition = mul(worldPosition, mViewProjBias);
}

float4 ShadowedPS(	float4 inShadowPosition : TEXCOORD0,
					float4 inShadowJitterPosition : TEXCOORD1,
					float3 inNormal : TEXCOORD2,
					float3 inToLight : TEXCOORD3
) : COLOR
{
	inToLight = normalize(inToLight);
	inNormal = normalize(inNormal);

	float lightDot=saturate(dot(inToLight, inNormal.xyz));
	float fShadow=CalculateShadow(inShadowPosition, inShadowJitterPosition);
	return (lightDot*vPointLightColour*fShadow)+vAmbientColour;
}

technique Shadowed
{
    pass P0
    {          
        VertexShader = compile vs_2_0 ShadowedVS();
        PixelShader  = compile ps_2_0 ShadowedPS();
		ZEnable = TRUE;
		ZWriteEnable = TRUE;
		ZFunc = LESSEQUAL;
		AlphaBlendEnable = FALSE;
		AlphaTestEnable = FALSE;
    }
}

texture tTexture;
sampler sTextureSamplerLinear = 
sampler_state
{
    Texture = <tTexture>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;
};

void TexturedVS(	float4 inPosition : POSITION,
					float4 inNormal : NORMAL,
					
					out float4 outPosition : POSITION,
					out	float2 outUV : TEXCOORD0
 )
{
	outPosition = mul(inPosition, mWorldViewProj);
	outUV = inPosition.xy*vUVTransform.xy+vUVTransform.zw;
}

float4 TexturedPS( float2 inUV : TEXCOORD0 ) : COLOR
{
	return tex2D( sTextureSamplerLinear, inUV ) * vConstColour;
}

technique TexturedBlend
{
    pass P0
    {          
        VertexShader = compile vs_2_0 TexturedVS();
        PixelShader  = compile ps_2_0 TexturedPS();
		ZEnable = FALSE;
		AlphaBlendEnable = TRUE;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		AlphaTestEnable = FALSE;
    }
}
