
import java.awt.Color;
import java.awt.GridLayout;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

/**
 *
 * @author Gussoh
 */
public class EmulatedLightPanel extends JPanel implements LightListener {

    Fasad fasad;
    JPanel[][] panels = new JPanel[3][6];

    public EmulatedLightPanel(Fasad fasad) {
        this.fasad = fasad;
        fasad.addLightListener(this);
        setLayout(new GridLayout(3, 6));

        for (int i = 0; i < panels.length; i++) {
            for (int j = 0; j < panels[i].length; j++) {
                panels[i][j] = new JPanel();
                panels[i][j].setBackground(Color.BLACK);
                panels[i][j].setOpaque(true);
                this.add(panels[i][j]);
            }
        }

    }

    public void setLights(boolean[][] lights) {
        try {

            Thread.sleep(350);
            if (lights.length < panels.length || lights[0].length < panels[0].length) {
                throw new UnsupportedOperationException("Lights array too small");
            }

            for (int i = 0; i < panels.length; i++) {
                for (int j = 0; j < panels[i].length; j++) {
                    if (lights[i][j]) {
                        panels[i][j].setBackground(Color.WHITE);
                    } else {
                        panels[i][j].setBackground(Color.BLACK);
                    }
                }
            }

            if (lights[1][1] || lights[1][2]) {
                panels[1][1].setBackground(Color.WHITE);
                panels[1][2].setBackground(Color.WHITE);
            }

            if (lights[1][3] || lights[1][4]) {
                panels[1][3].setBackground(Color.WHITE);
                panels[1][4].setBackground(Color.WHITE);
            }

            validate();
        } catch (InterruptedException ex) {
        }
    }
}
