///////////////////////////////////////////////////////////////////////
// Moira library
// Copyright (c) 2005 Camilla Berglund <elmindreda@elmindreda.org>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.
//
///////////////////////////////////////////////////////////////////////

#include <moira/Config.h>
#include <moira/Portability.h>
#include <moira/Core.h>
#include <moira/Vector.h>
#include <moira/Bezier.h>
#include <moira/Quaternion.h>
#include <moira/Transform.h>
#include <moira/Stream.h>
#include <moira/Resource.h>
#include <moira/XML.h>
#include <moira/Animation.h>

///////////////////////////////////////////////////////////////////////

namespace moira
{
  
///////////////////////////////////////////////////////////////////////

Animation::Animation(const String& name):
  Resource<Animation>(name),
  duration(1.0)
{
}

void Animation::evaluate(Time time, Transform3& transform)
{
  positions.evaluate((float) (time / duration), transform.position);
  rotations.evaluate((float) (time / duration), transform.rotation);
}

///////////////////////////////////////////////////////////////////////

Animation* AnimationCodecXML::read(const Path& path, const String& name)
{
  return AnimationCodec::read(path, name);
}

Animation* AnimationCodecXML::read(Stream& stream, const String& name)
{
  // TODO: The code.

  return NULL;
}

bool AnimationCodecXML::write(const Path& path, const Animation& animation)
{
  return AnimationCodec::write(path, animation);
}

bool AnimationCodecXML::write(Stream& stream, const Animation& animation)
{
  // TODO: The code.

  return false;
}

bool AnimationCodecXML::onBeginElement(const String& name)
{
  // TODO: The code.

  return true;
}

bool AnimationCodecXML::onEndElement(const String& name)
{
  // TODO: The code.

  return true;
}

///////////////////////////////////////////////////////////////////////

} /*namespace moira*/

///////////////////////////////////////////////////////////////////////
