#!/bin/sh
#
# This script creates the Makefile.am file, for use with automake.
# It requires printf(1) and (indirectly) Ruby.
#

self=`basename $0`

# Collect header files.
files=`ls *.h|sed -e '/Config\.h/d;/Signal\.h/d'`
if [ -z "$files" ]; then
  echo "$self: No header files; punting"
  exit 1
fi

# Add signal header (don't force the user to install Ruby).
files="Signal.h $files"

rm -f Makefile.am

# Warn the user against editing generated data.
echo "# Generated by $self." >> Makefile.am
echo '# DO NOT EDIT THIS FILE!' >> Makefile.am
echo >> Makefile.am

# Rule for non-distribution of configuration header.
echo 'nodist_pkginclude_HEADERS = Config.h' >> Makefile.am
echo >> Makefile.am

# Rule for installing headers.
echo -n 'pkginclude_HEADERS =' >> Makefile.am
for file in $files; do
  if [ "$file" != 'Moira.h' ]; then
    if [ -z "`grep \"$file\" Moira.h`" ]; then
      echo "$file: warning; header not included by Moira.h"
    fi
  fi
  echo -n " $file" >> Makefile.am
done
echo >> Makefile.am
echo >> Makefile.am

# Rule for building configuration header.
echo 'Config.h: @top_srcdir@/include/config.h' \
     '@top_srcdir@/build/makeconfig.sh' \
     '@top_srcdir@/build/makeconfig.sed' >> Makefile.am
printf '\t@top_srcdir@/build/makeconfig.sh $< $@\n' >> Makefile.am
echo >> Makefile.am

# Rule for building signal header (this is where to edit the argument count).
echo 'Signal.h: @top_srcdir@/build/makesignal.rb' >> Makefile.am
printf '\t$< $@ 4\n' >> Makefile.am
echo >> Makefile.am

# Rule for re-distributing ourself.
echo "EXTRA_DIST = $self" >> Makefile.am
echo >> Makefile.am

