///////////////////////////////////////////////////////////////////////
// Moira library
// Copyright (c) 2006 Camilla Berglund <elmindreda@elmindreda.org>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.
//
///////////////////////////////////////////////////////////////////////
#ifndef MOIRA_RECTANGLE_H
#define MOIRA_RECTANGLE_H
///////////////////////////////////////////////////////////////////////

#include <stack>

///////////////////////////////////////////////////////////////////////

namespace moira
{
  
///////////////////////////////////////////////////////////////////////

class Rectangle
{
public:
  Rectangle(void);
  Rectangle(const Vector2& position, const Vector2& size);
  Rectangle(float x, float y, float width, float height);
  bool contains(const Vector2& point) const;
  bool contains(const Rectangle& other) const;
  bool intersects(const Rectangle& other) const;
  bool clipBy(const Rectangle& other);
  void envelop(const Rectangle& other);
  void normalize(void);
  bool operator == (const Rectangle& other) const;
  bool operator != (const Rectangle& other) const;
  Rectangle operator + (const Vector2& offset) const;
  Rectangle operator - (const Vector2& offset) const;
  Rectangle operator * (const Vector2& scale) const;
  Rectangle& operator += (const Vector2& offset);
  Rectangle& operator -= (const Vector2& offset);
  Rectangle& operator *= (const Vector2& scale);
  Vector2 getCenter(void) const;
  void getBounds(float& minX, float& minY, float& maxX, float& maxY) const;
  void setBounds(float minX, float minY, float maxX, float maxY);
  void set(const Vector2& newPosition, const Vector2& newSize); 
  void set(float x, float y, float width, float height);
  Vector2 position;
  Vector2 size;
};

///////////////////////////////////////////////////////////////////////

class RectangleClipStack
{
public:
  RectangleClipStack(void);
  bool push(const Rectangle& rectangle);
  void pop(void);
  bool isEmpty(void) const;
  unsigned int getCount(void) const;
  const Rectangle& getTop(void) const;
  const Rectangle& getTotal(void) const;
private:
  struct Entry
  {
    Rectangle local;
    Rectangle total;
  };
  std::stack<Entry> entries;
};

///////////////////////////////////////////////////////////////////////

} /*namespace moira*/

///////////////////////////////////////////////////////////////////////
#endif /*MOIRA_RECTANGLE_H*/
///////////////////////////////////////////////////////////////////////
