///////////////////////////////////////////////////////////////////////
// Moira library
// Copyright (c) 2005 Camilla Berglund <elmindreda@elmindreda.org>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.
//
///////////////////////////////////////////////////////////////////////
#ifndef MOIRA_MOIRA_H
#define MOIRA_MOIRA_H
///////////////////////////////////////////////////////////////////////

#include <moira/Config.h>

#include <moira/Portability.h>

#include <moira/Core.h>
#include <moira/Signal.h>
#include <moira/Node.h>
#include <moira/Timer.h>
#include <moira/Attribute.h>

#include <moira/Color.h>
#include <moira/Vector.h>
#include <moira/Matrix.h>
#include <moira/Quaternion.h>
#include <moira/Transform.h>
#include <moira/Random.h>

#include <moira/AABB.h>
#include <moira/Segment.h>
#include <moira/Rectangle.h>
#include <moira/Plane.h>
#include <moira/Ray.h>
#include <moira/Sphere.h>
#include <moira/Triangle.h>
#include <moira/Frustum.h>
#include <moira/Bezier.h>

#include <moira/Stream.h>
#include <moira/Socket.h>
#include <moira/Resource.h>
#include <moira/XML.h>

#include <moira/Animation.h>
#include <moira/Image.h>
#include <moira/Font.h>
#include <moira/Mesh.h>

#include <moira/MeshIO.h>
#include <moira/ImageIO.h>
#include <moira/ImageGenerators.h>

///////////////////////////////////////////////////////////////////////

namespace moira
{

///////////////////////////////////////////////////////////////////////

/*! @brief Creates the default objects.
 *
 *  Creates and sets up the default objects, such as the default font
 *  and instances of all default resource codecs.  If you don't need
 *  these, then you don't need to call this.
 *
 *  @remarks If you do call it, it's considered polite to call
 *  moira::shutdown as well.
 */
bool initialize(void);

/*! @brief Destroys the default objects.
 *
 *  Destroys all objects created by moira::initialize.
 */
void shutdown(void);

///////////////////////////////////////////////////////////////////////

} /*namespace moira*/

///////////////////////////////////////////////////////////////////////
#endif /*MOIRA_MOIRA_H*/
///////////////////////////////////////////////////////////////////////
