///////////////////////////////////////////////////////////////////////
// Moira library
// Copyright (c) 2006 Camilla Berglund <elmindreda@elmindreda.org>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.
//
///////////////////////////////////////////////////////////////////////
#ifndef MOIRA_ATTRIBUTE_H
#define MOIRA_ATTRIBUTE_H
///////////////////////////////////////////////////////////////////////

namespace moira
{
  
///////////////////////////////////////////////////////////////////////

class Decorated;

///////////////////////////////////////////////////////////////////////

class Attribute
{
public:
  Attribute(Decorated& decorated, const String& name);
  ~Attribute(void);
  Attribute& createMember(const String& name);
  void destroyMember(const String& name);
  void destroyMembers(void);
  Attribute& operator [] (const String& name);
  const Attribute& operator [] (const String& name) const;
  float asFloat(void) const;
  void setFloatValue(float newValue);
  int asInteger(void) const;
  void setIntegerValue(int newValue);
  bool asBoolean(void) const;
  void setBooleanValue(bool newValue);
  const String& asString(void) const;
  void setStringValue(const String& newValue);
  const String& getName(void) const;
  Attribute* getMember(const String& name);
  const Attribute* getMember(const String& name) const;
private:
  typedef std::list<Attribute> List;
  Decorated& decorated;
  String name;
  String value;
  List members;
};

///////////////////////////////////////////////////////////////////////

class Decorated
{
  friend class Attribute;
public:
  Attribute& createAttribute(const String& name);
  void destroyAttribute(const String& name);
  void destroyAttributes(void);
  bool hasAttribute(const String& name) const;
  Attribute* getAttribute(const String& name);
  const Attribute* getAttribute(const String& name) const;
  SignalProxy1<void, const Attribute&> getChangeValueSignal(void);
  SignalProxy1<void, const Attribute&> getCreateAttributeSignal(void);
  SignalProxy1<void, const Attribute&> getDestroyAttributeSignal(void);
private:
  typedef std::list<Attribute> AttributeList;
  AttributeList attributes;
  Signal1<void, const Attribute&> changeValueSignal;
  Signal1<void, const Attribute&> createAttributeSignal;
  Signal1<void, const Attribute&> destroyAttributeSignal;
};

///////////////////////////////////////////////////////////////////////

} /*namespace moira*/

///////////////////////////////////////////////////////////////////////
#endif /*MOIRA_ATTRIBUTE_H*/
///////////////////////////////////////////////////////////////////////
