
#include <wendy/Wendy.h>

using namespace moira;
using namespace wendy;

#include "Glow.h"
#include "Water.h"
#include "Planet.h"

PlanetEffect::PlanetEffect(demo::EffectType& type, const String& name):
  demo::Effect(type, name)
{
}

bool PlanetEffect::init(void)
{
  glow = Glow::createInstance(256);
  if (!glow)
    return false;

  water = Water::createInstance(1000.f);
  if (!water)
    return false;

  WaterNode* waterNode = new WaterNode();
  waterNode->setWater(water);
  waterNode->getLocalTransform().position.y = 0.1f;
  scene.addNode(*waterNode);

  Ref<render::Terrain> terrain = render::Terrain::readInstance("island");
  if (!terrain)
    return false;

  render::TerrainNode* terrainNode = new render::TerrainNode();
  terrainNode->setTerrain(terrain);
  scene.addNode(*terrainNode);

  camera.setFOV(60.f);

  cameraNode = new render::CameraNode();
  cameraNode->setCameraName(camera.getName());
  cameraNode->getLocalTransform().position.set(0.f, 10.f, 0.f);
  scene.addNode(*cameraNode);

  BezierPoint3 point;

  point.position.set(0.f, 10.f, 100.f);
  point.direction.set(0.f, 0.f, -1.f);
  motionTrack.points.push_back(point);

  point.position.set(0.f, 10.f, -100.f);
  point.direction.set(0.f, 0.f, -1.f);
  motionTrack.points.push_back(point);

  return true;
}

void PlanetEffect::update(Time deltaTime)
{
  const float progress = (float) getTimeElapsed() / (float) getDuration();

  cameraNode->getLocalTransform().position = motionTrack(progress);

  scene.setTimeElapsed(getTimeElapsed());
}

void PlanetEffect::prepare(void) const
{
  render::Queue queue(camera);
  scene.enqueue(queue);
  water->prepare(queue);
  //glow->prepare(queue);
}

void PlanetEffect::render(void) const
{
  render::Queue queue(camera);
  scene.enqueue(queue);
  queue.render();

  //glow->render();

  renderChildren();
}

