
#include <wendy/Wendy.h>

using namespace moira;
using namespace wendy;

#include "Noise.h"

NoiseEffect::NoiseEffect(demo::EffectType& type, const String& name):
  demo::Effect(type, name)
{
}

bool NoiseEffect::init(void)
{
  GL::Texture* noiseTexture = GL::Texture::readInstance("noise");
  if (!noiseTexture)
    return false;

  noisePass.setDefaultColor(ColorRGBA::WHITE);
  noisePass.setBlendFactors(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  noisePass.setDepthTesting(false);
  noisePass.setDepthWriting(false);
  
  GL::TextureLayer& noiseLayer = noisePass.createTextureLayer();
  noiseLayer.setTexture(noiseTexture);
  noiseLayer.setCombineMode(GL_MODULATE);

  return true;
}

void NoiseEffect::update(Time deltaTime)
{
  float progress = (float) getTimeElapsed() / (float) getDuration();

  noisePass.setDefaultColor(ColorRGBA(1.f, 1.f, 1.f, sinf(progress * M_PI)));
}

void NoiseEffect::render(void) const
{
  GL::Renderer* renderer = GL::Renderer::get();

  renderer->begin2D();

  noisePass.apply();

  RandomArea area(Vector2::ZERO, Vector2::ONE);

  render::Sprite2 sprite;
  sprite.mapping.position = area.generate();
  sprite.position.set(0.5f, 0.5f);
  sprite.render();

  renderer->end();

  renderChildren();
}

