
#include <wendy/Wendy.h>

using namespace moira;
using namespace wendy;

#include "Laser.h"

void enqueueLaserBeam(render::Queue& queue, const Segment3& segment, const Transform3& transform)
{
  render::Style* style = render::Style::findInstance("purple");
  if (!style)
    return;

  render::Technique* technique = style->getActiveTechnique();
  if (!technique)
    return;

  const unsigned int segments = 8;

  GL::Renderer* renderer = GL::Renderer::get();

  GL::VertexRange vertexRange;

  if (!renderer->allocateVertices(vertexRange, segments * 2, GL::Vertex3fv::format))
    return;

  GL::IndexRange indexRange;

  if (!renderer->allocateIndices(indexRange, segments * 4, GL::IndexBuffer::USHORT))
    return;

  Vector3 vector = segment.end - segment.start;

  const float length = vector.length();

  Transform3 inner;
  inner.rotation.setVectorRotation(-vector.normalize());
  inner.position = segment.start;

  Transform3 final = inner;
  final.concatenate(transform);

  GL::Vertex3fv* vertices = (GL::Vertex3fv*) vertexRange.lock();

  for (unsigned int i = 0;  i < segments;  i++)
  {
    Vector3& start = vertices[i].position;
    start.set(cosf(M_PI * 2.f * i / segments) * 0.2f,
              sinf(M_PI * 2.f * i / segments) * 0.2f,
	      0.f);

    Vector3& end = vertices[i + segments].position;
    end.set(cosf(M_PI * 2.f * i / segments) * 0.2f,
            sinf(M_PI * 2.f * i / segments) * 0.2f,
	    -length);
  }

  vertexRange.unlock();

  const unsigned int offset = vertexRange.getStart();

  unsigned short* indices = (unsigned short*) indexRange.lock();

  for (unsigned int i = 0;  i < segments;  i++)
  {
    indices[i * 4 + 0] = offset + (i + 1) % segments;
    indices[i * 4 + 1] = offset + i;
    indices[i * 4 + 2] = offset + i + segments;
    indices[i * 4 + 3] = offset + segments + (i + 1) % segments;
  }

  indexRange.unlock();

  render::Operation& operation = queue.createOperation();
  operation.technique = technique;
  operation.transform = final;
  operation.vertexBuffer = vertexRange.getVertexBuffer();
  operation.indexBuffer = indexRange.getIndexBuffer();
  operation.start = indexRange.getStart();
  operation.count = indexRange.getCount();
  operation.renderMode = GL_QUADS;
}

