
#include <wendy/Wendy.h>

using namespace moira;
using namespace wendy;

#include "Glow.h"
#include "Island.h"

IslandEffect::IslandEffect(demo::EffectType& type, const String& name):
  demo::Effect(type, name),
  outside(true)
{
}

bool IslandEffect::init(void)
{
  glow = Glow::createInstance(256);
  if (!glow)
    return false;

  render::Mesh* dome = render::Mesh::readInstance("dome");
  if (!dome)
    return false;

  terrain = render::Terrain::readInstance("island");
  if (!mesh)
    return false;

  render::TerrainNode* terrainNode = new render::TerrainNode();
  terrainNode->setTerrain(terrain);
  scene.addNode(*terrainNode);

  domeNode = new render::MeshNode();
  domeNode->setMesh(dome);
  scene.addNode(*domeNode);

  camera.setFOV(60.f);

  cameraNode = new render::CameraNode();
  cameraNode->setCameraName(camera.getName());
  scene.addNode(*cameraNode);

  return true;
}

void IslandEffect::update(Time deltaTime)
{
  scene.setTimeElapsed(getTimeElapsed());

  domeNode->getLocalTransform().position = cameraNode->getLocalTransform().position;
}

void IslandEffect::prepare(void) const
{
  render::Queue queue(camera);
  scene.enqueue(queue);
  glow->prepare(queue);
}

void IslandEffect::render(void) const
{
  render::Queue queue(camera);
  scene.enqueue(queue);
  queue.render();

  glow->render();
}

