
class HyperCube : public render::Renderable, public RefObject<HyperCube>
{
public:
  void enqueue(render::Queue& queue, const Transform3& transform) const;
  const Sphere& getBounds(void) const;
  void setTimeElapsed(Time newTime);
  static HyperCube* createInstance(void);
private:
  HyperCube(void);
  bool init(void);
  struct Vertex
  {
    Vector4 position;
    Vector3 projected;
  };
  Ref<render::Mesh> ball;
  Ref<render::Style> style;
  Vertex vertices[16];
  Sphere bounds;
};

class HyperNode : public render::SceneNode
{
public:
  HyperNode(void);
  void setCube(HyperCube* newCube);
protected:
  void update(Time deltaTime);
  void restart(void);
  void enqueue(render::Queue& queue, render::QueuePhase phase) const;
private:
  Time elapsed;
  Ref<HyperCube> cube;
};

class HyperEffect : public demo::Effect
{
public:
  HyperEffect(demo::EffectType& type, const String& name);
  bool init(void);
private:
  void update(Time deltaTime);
  void prepare(void) const;
  void render(void) const;
  enum Sequence
  {
    INITIAL,
    PRESENTS,
    ORIBIT,
  };
  HyperNode* hyperNode;
  Ptr<Glow> glow;
  Ref<GL::Texture> presentsTexture;
  GL::Pass presentsPass;
  render::Scene scene;
  render::Camera camera;
  render::CameraNode* cameraNode;
  render::MeshNode* domeNode;
  BezierTrack3 curveTrack;
  VectorTrack3 slideTrack;
  demo::EnumProperty sequence;
};

