
#include <wendy/Wendy.h>

using namespace moira;
using namespace wendy;

#include "Glow.h"
#include "Credits.h"

void CreditsAffector::affectParticle(render::Particle& particle,
                                     unsigned int particleIndex,
		                     Time deltaTime)
{
  particle.color.a = 1.f - particle.elapsed / particle.duration;
}

CreditsEffect::CreditsEffect(demo::EffectType& type, const String& name):
  demo::Effect(type, name),
  angle(*this, "Angle", -M_PI, M_PI),
  emission(*this, "Emission", 0.f, 400.f)
{
}

bool CreditsEffect::init(void)
{
  glow = Glow::createInstance(256);
  if (!glow)
    return false;

  petalMesh = render::Mesh::readInstance("petal");
  if (!petalMesh)
    return false;

  platformMesh = render::Mesh::readInstance("credits");
  if (!platformMesh)
    return false;

  particleStyle = render::Style::readInstance("particle");
  if (!particleStyle)
    return false;

  Ref<render::Terrain> terrain = render::Terrain::readInstance("hills");
  if (!terrain)
    return false;
  
  render::TerrainNode* terrainNode = new render::TerrainNode();
  terrainNode->setTerrain(terrain);
  terrainNode->getLocalTransform().position.y = -3.f;
  scene.addNode(*terrainNode);

  const char* names[] = { "cybear", "elmindreda", "kallisti",
                          "salome", NULL };

  for (unsigned int i = 0;  names[i] != NULL;  i++)
  {
    String name;
    name.append("credits_");
    name.append(names[i]);

    Ref<GL::Texture> texture = GL::Texture::readInstance(name);
    if (!texture)
      return false;

    Ref<render::Style> style = new render::Style();
    render::Technique& technique = style->createTechnique();
    GL::Pass& pass = technique.createPass();
    pass.setDefaultColor(ColorRGBA::WHITE);
    pass.setBlendFactors(GL_ONE, GL_ONE);
    pass.setDepthWriting(false);
    GL::TextureLayer& layer = pass.createTextureLayer();
    layer.setTexture(texture);
    layer.setCombineMode(GL_MODULATE);
    layer.setAddressMode(GL_CLAMP_TO_EDGE);

    const float size = 1.f;

    Quaternion rotation;
    rotation.setAxisRotation(Vector3::Y, M_PI * 2.f * i / 4.f);

    Vector3 position(0.f, i + 1.f, 4.f);
    rotation.rotateVector(position);

    render::SpriteNode* spriteNode = new render::SpriteNode();
    spriteNode->setSpriteSize(Vector2(size * texture->getWidth() / (float) texture->getHeight(), size));
    spriteNode->getLocalTransform().position = position;
    spriteNode->setStyle(style);
    scene.addNode(*spriteNode);
  }

  RandomVolume volume(Vector3(-10.f, -3.f, 5.f),
                      Vector3(10.f, 8.f, 10.f));

  for (unsigned int i = 0;  i < 10;  i++)
  {
    BezierPoint3 point;

    Vector3 position;

    do
    {
      position = volume.generate();
      position.y = std::max(position.y, terrain->getHeight(Vector2(position.x, position.z)) + 1.f);
    }
    while (position.length() < 5.f);

    point.position = position;
    position.normalize();

    Vector3 direction;

    do
    {
      direction = (volume.generate() - volume.generate()).normalize();
    }
    while (fabsf(direction.normalize().dotProduct(position.normalize())) > 0.6f);

    point.direction = direction;

    motionTrack.points.push_back(point);
  }

  render::MeshNode* platformNode = new render::MeshNode();
  platformNode->setMesh(platformMesh);
  scene.addNode(*platformNode);

  for (unsigned int i = 0;  i < 4;  i++)
  {
    Vector3 position = Vector3(0.f, 0.f, 0.3f);

    Quaternion rotation;
    rotation.setAxisRotation(Vector3::Y, M_PI * i / 2.f);
    rotation.rotateVector(position);

    render::SceneNode* node = new render::SceneNode();
    node->getLocalTransform().rotation = rotation;
    node->getLocalTransform().position = position;
    platformNode->addChild(*node);

    petalNodes[i] = new render::MeshNode();
    petalNodes[i]->setMesh(petalMesh);
    node->addChild(*petalNodes[i]);
  }

  system.setParticleCount(1000);
  system.setParticleSize(Vector2(0.3f, 0.3f));
  system.setStyle(particleStyle);

  const ColorRGBA color(1.0f, 0.1f, 1.f, 1.f);

  emitter = new render::DefaultParticleEmitter();
  emitter->setColorRange(RandomRGBA(color, color));
  emitter->setDurationRange(RandomRange(4.f, 8.f));
  emitter->setVelocityRange(RandomRange(3.f, 5.f));
  emitter->setAngleRange(RandomRange(0.f, M_PI / 4.f));
  emitter->setOriginVolume(RandomVolume(Vector3::ZERO, Vector3::ZERO));
  system.addEmitter(*emitter);

  render::PlanarGravityParticleAffector* gravityAffector = new render::PlanarGravityParticleAffector();
  gravityAffector->setGravity(Vector3(0.f, -1.f, 0.f));
  system.addAffector(*gravityAffector);

  CreditsAffector* creditsAffector = new CreditsAffector();
  system.addAffector(*creditsAffector);

  render::ParticleSystemNode* systemNode = new render::ParticleSystemNode();
  systemNode->setSystemName(system.getName());
  platformNode->addChild(*systemNode);

  camera.setFOV(60.f);

  cameraNode = new render::CameraNode();
  cameraNode->setCameraName(camera.getName());
  cameraNode->getLocalTransform().position.z = 5.f;
  scene.addNode(*cameraNode);

  return true;
}

void CreditsEffect::update(Time deltaTime)
{
  emitter->setEmissionRate(emission.getValue(getTimeElapsed()));

  float progress = getTimeElapsed() / getDuration();

  Vector3 position = motionTrack(progress);

  cameraNode->getLocalTransform().position = position;
  cameraNode->getLocalTransform().rotation.setVectorRotation((position - Vector3(0.f, 1.f, 0.f)).normalize());

  for (unsigned int i = 0;  i < 4;  i++)
    petalNodes[i]->getLocalTransform().rotation.setAxisRotation(Vector3::X, angle.getValue(getTimeElapsed()));

  scene.setTimeElapsed(getTimeElapsed());
}

void CreditsEffect::prepare(void) const
{
  render::Queue queue(camera);
  scene.enqueue(queue);
  glow->prepare(queue);
}

void CreditsEffect::render(void) const
{
  render::Queue queue(camera);
  scene.enqueue(queue);
  queue.render();

  glow->render();

  renderChildren();
}

