uniform sampler2D colorMap;

varying float alpha;

vec2 pixelSize = vec2(1.0 / 1024.0, 1.0 / 768.0) * 2.0;

void main()
{			
	vec2 temp = vec2(0.5,0.5);
	
	vec2 newCoords;
	
	newCoords.x = gl_TexCoord[0].x; + 1.0f*0.0625 * sin(gl_TexCoord[0].y*16*6.28);
	newCoords.y = gl_TexCoord[0].y;
	
	//gl_FragColor = alpha * texture2D(colorMap, newCoords.st);
	
	vec2 base = vec2(newCoords.x, 8*pixelSize.y * newCoords.y);
	vec4 total = texture2D(colorMap, newCoords);
	total += texture2D(colorMap, newCoords + vec2(1, 0)*pixelSize*(1-alpha));
	total += 0.9*texture2D(colorMap, newCoords + vec2(2, 0)*pixelSize*(1-alpha));
	total += 0.8*texture2D(colorMap, newCoords + vec2(3, 0)*pixelSize*(1-alpha));
	total += 0.7*texture2D(colorMap, newCoords + vec2(4, 0)*pixelSize*(1-alpha));
	total += 0.6*texture2D(colorMap, newCoords + vec2(5, 0)*pixelSize*(1-alpha));
	total += 0.5*texture2D(colorMap, newCoords + vec2(6, 0)*pixelSize*(1-alpha));
	total += 0.4*texture2D(colorMap, newCoords + vec2(7, 0)*pixelSize*(1-alpha));
	gl_FragColor = gl_FrontLightProduct[0].diffuse;
	gl_FragColor.a = alpha* total.r / 6.0;


}