uniform sampler2D colorMap;
uniform float luminanceCutoff;

void main()
{
	vec3 color = texture2D(colorMap, gl_TexCoord[0].st).rgb;
	
	float luminance = dot(vec3(0.2125, 0.7154, 0.0721), color);
	if(luminance > luminanceCutoff) {
		gl_FragColor.rgb = color.rgb;
	}
	else {
		gl_FragColor.rgb = vec3(0,0,0);
	}
	
	gl_FragColor.a = 1.0;
}

// brightpass.cg
// LDR bright-pass filter; keeps pixels with an intensity greater than a threshold
// (max of the three color channels), while scaling others down to 0

/*float threshold = 0.8;

float4 main (samplerRECT prevTex : TEXUNIT0, float2 tc: TEXCOORD0) : COLOR
{
	float4 prevValue = texRECT(prevTex, tc);
	float intensity = max(max(prevValue.x, prevValue.y), prevValue.z);
	return (intensity > threshold) ? prevValue : float4(0, 0, 0, 1);
}*/