/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef SOUND_H
#define SOUND_H

#include "SDL_mixer.h"

class Sound {
public:
	void init(const char* menuIntro, const char* menu, const char* game);
	
	static Sound& getInstance() {
		return m_instance;
	}

	void setState(bool enabled) {
		if (!enabled) {
			Mix_PauseMusic();
			m_ignore = 1;
		} else if (m_ignore) {
			m_ignore = 0;
			if (m_playing == MENU) {
				Mix_HookMusicFinished(menuNext);
				Mix_PlayMusic(m_menuIntro, 1);
			}
			else
				Mix_PlayMusic(m_game, -1);
		}
	}
	void playMenu() {
		m_playing = MENU;
		if (m_ignore)
			return;
		if (!m_menu) {
			Mix_PauseMusic();
			return;
		}
		Mix_HookMusicFinished(menuNext);
		Mix_PlayMusic(m_menuIntro, 1);
	}
	void playGame() {
		m_playing = GAME;
		if (m_ignore)
			return;
		if (!m_game) {
			Mix_PauseMusic();
			return;
		}
		Mix_PlayMusic(m_game, -1);
	}
	bool isEnabled() {
		return !m_ignore;
	}
	
private:
	static Sound m_instance;

	Sound(): m_menu(0), m_game(0), m_ignore(0) {}
	Sound(const Sound&);

	Mix_Music* m_menuIntro;
	Mix_Music* m_menu;
	Mix_Music* m_game;

	bool m_ignore;

	enum { MENU, GAME } m_playing;
	
	static void menuNext() {
		Mix_HookMusicFinished(0);
		if (m_instance.m_playing == MENU)
			Mix_PlayMusic(m_instance.m_menu, -1);
	}
};

#endif
