/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef OPTIONS_H
#define OPTIONS_H

#include <map>
#include <string>
#include <boost/spirit/iterator/file_iterator.hpp>

#pragma pack(push, 1)
struct OptionData {
	short resY, resX;
	float sensitivity;
	bool fullscreen;
};
#pragma pack(pop)

class Options {
public:
	Options() {}
	Options(const char* file);

	bool read(const char* file);
	void write(const char* file);

	std::string& operator[](const std::string& key) {
		return m_data[key];
	}
	
private:
	typedef std::map<std::string, std::string> StrMap;
	std::map<std::string, std::string> m_data;

	typedef boost::spirit::file_iterator<char> iter_t;
	std::string m_tmpStr;
	void setVar(iter_t begin, iter_t end) {
		m_tmpStr.assign(begin, end);
	}
	void setValue(iter_t begin, iter_t end) {
		m_data[m_tmpStr].assign(begin, end);
	}
};

#endif
