/* Copyright (C) 2007  Mikko Sysikaski <mikko.sysikaski@gmail.com>
 * This program is free software distributed under GNU General Public License
 * version 3 or (at your option) any later version.
 * No warranty of any kind is provided. See the accompanying file COPYING for details.
 */

#ifndef MENUBG_H
#define MENUBG_H

#include <GL/gl.h>

class MenuBG {
public:
	static void init() {
		m_instance.doInit();
	}
	static void draw() {
		m_instance.doDraw();
	}
	static void reloadTexture();

private:
	GLuint m_texNum;
	GLubyte* m_texture;

	void setPix(float x, float y, GLubyte res[3]);

	void doInit();
	void doDraw();

	static MenuBG m_instance;

	MenuBG() {}
	MenuBG(const MenuBG&);
};

#endif
