#include "credits.h"
#include "menubg.h"
#include "idler.h"
#include "lcd.h"
#include <GL/gl.h>
#include <algorithm>

Credits::Credits()
{
	m_devs.push_back(Dev("mikko \"sisu\"\nsysikaski", "code graphics,\nlevels"));
	m_devs.push_back(Dev("eetu \"koodr\"\nlehtonen", "music"));
	m_devs.push_back(Dev("toni \"hifi\"\nspets", "levels"));
#ifdef _NOUTF8
	m_devs.push_back(Dev("tatu \"mozz\"\nsepp;-lassila", "levels"));
#else
	m_devs.push_back(Dev("tatu \"mozz\"\nseppä-lassila", "levels"));
#endif
}

void Credits::exec()
{
	m_place = -1.2f;
	Idler idle(50);
	SDL_Event e;
	while(m_place <= 2.6f) {
		uint time = idle.idle();
		
		while (SDL_PollEvent(&e)) {
			if (e.type == SDL_QUIT)
				return;
			else if (e.type == SDL_KEYDOWN) {
				SDLKey key = e.key.keysym.sym;
				if (key == SDLK_ESCAPE || key == SDLK_RETURN || key == SDLK_SPACE)
					return;
			}
		}
		m_place += 0.0005f*time;
		draw();
	}
}

void Credits::draw()
{
	glLoadIdentity();
	MenuBG::draw();
	
	glTranslatef(-0.9, m_place, 0);
	glScalef(0.1, 0.1, 0.1);
	glColor3f(0, 1, 0);
	glLineWidth(3);
	glPointSize(3);
	for(DevVect::iterator i=m_devs.begin(); i!=m_devs.end(); ++i) {
		int linea = LCD::print(i->first.c_str());
		glTranslatef(0, linea*1.2f, 0);
		
		glPushMatrix();
		glTranslatef(10, 0, 0);
		glColor3f(1, 0, 0);
		int lines = LCD::print(i->second.c_str());
		glColor3f(0, 1, 0);
		glPopMatrix();
		
		glTranslatef(0, -2-1.5f*std::max(lines, linea), 0);
	}
	glTranslatef(3, -2, 0);
	glColor3f(1, 0, 1);
	LCD::print("poksi productions");
	
	SDL_GL_SwapBuffers();
}
