#include <math.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_opengl.h>
GLuint LoadTextureRGB(char *filu,bool gen) {
	SDL_Surface *s;
	GLuint texture;

	if(s=IMG_Load(filu)) {
		//if(gen)
			glGenTextures(1,&texture);
		glBindTexture(GL_TEXTURE_2D,texture);
		glTexImage2D(GL_TEXTURE_2D,0,4,s->w,s->h,0,GL_RGB,GL_UNSIGNED_BYTE,s->pixels);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	}
	return texture;
}

GLuint LoadTexture(char *filu,bool gen) {
	SDL_Surface *s;
	GLuint texture;

	if(s=IMG_Load(filu)) {
		//if(gen)
			glGenTextures(1,&texture);
		glBindTexture(GL_TEXTURE_2D,texture);
		glTexImage2D(GL_TEXTURE_2D,0,4,s->w,s->h,0,GL_RGBA,GL_UNSIGNED_BYTE,s->pixels);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	}
	return texture;
}


int init(void) {
	if(SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO)!=0){
		return 1;
	}

	SDL_GL_SetAttribute(SDL_GL_RED_SIZE,8);
	SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE,8);
	SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE,8);

	SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE,16);

	SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER,1);

	SDL_SetVideoMode(640,480,0,SDL_OPENGL|SDL_FULLSCREEN);
	glEnable(GL_TEXTURE_2D);
	//glShadeModel(GL_SMOOTH);
	glClearColor(0.0f,0.0f,0.0f,0.5f);
	glClearDepth(1.0f);
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);

	glViewport(0,0,640,480);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0,640,0,480,-1,-1);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	return 0;
}
