/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Cursor;
import java.awt.Robot;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.AWTCanvasInputImplementation;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.AWTUtil;
import org.lwjgl.opengl.KeyboardEventQueue;
import org.lwjgl.opengl.MouseEventQueue;

abstract class AbstractAWTInput
implements AWTCanvasInputImplementation {
    private AWTGLCanvas canvas;
    private Robot robot;
    private KeyboardEventQueue keyboard_queue;
    private MouseEventQueue mouse_queue;
    private volatile boolean grab;

    protected AbstractAWTInput(AWTGLCanvas canvas) {
        this.canvas = canvas;
        this.robot = AWTUtil.createRobot(canvas);
    }

    protected synchronized MouseEventQueue getMouseEventQueue() {
        return this.mouse_queue;
    }

    public synchronized void grabMouse(boolean grab) {
        this.grab = grab;
        if (this.mouse_queue != null) {
            this.mouse_queue.setGrabbed(grab);
        }
    }

    protected boolean isGrabbed() {
        return this.grab;
    }

    protected final AWTGLCanvas getCanvas() {
        return this.canvas;
    }

    public final void init() {
        this.canvas.setInput(this);
    }

    public synchronized void destroy() {
        this.canvas.setInput(null);
        this.canvas = null;
    }

    public final int getWidth() {
        return this.canvas.getWidth();
    }

    public final int getHeight() {
        return this.canvas.getHeight();
    }

    public boolean hasWheel() {
        return AWTUtil.hasWheel();
    }

    public int getButtonCount() {
        return AWTUtil.getButtonCount();
    }

    public void createMouse() throws LWJGLException {
        this.mouse_queue = this.createMouseQueue();
        this.mouse_queue.register();
    }

    protected MouseEventQueue createMouseQueue() {
        return new MouseEventQueue(this.getCanvas());
    }

    public void destroyMouse() {
        this.mouse_queue.unregister();
    }

    public int getNativeCursorCapabilities() {
        return AWTUtil.getNativeCursorCapabilities();
    }

    public void setCursorPosition(int x, int y) {
        AWTUtil.setCursorPosition(this.canvas, this.robot, x, y);
    }

    public void setNativeCursor(Object handle) throws LWJGLException {
        this.canvas.setCursor((Cursor)handle);
    }

    public int getMinCursorSize() {
        return AWTUtil.getMinCursorSize();
    }

    public int getMaxCursorSize() {
        return AWTUtil.getMaxCursorSize();
    }

    public synchronized void createKeyboard() throws LWJGLException {
        this.keyboard_queue = new KeyboardEventQueue(this.canvas);
        this.keyboard_queue.register();
    }

    public synchronized void destroyKeyboard() {
        if (this.keyboard_queue != null) {
            this.keyboard_queue.unregister();
        }
    }

    public Object createCursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) throws LWJGLException {
        return AWTUtil.createCursor(width, height, xHotspot, yHotspot, numImages, images, delays);
    }

    public void destroyCursor(Object cursor_handle) {
    }

    public synchronized void readMouse(ByteBuffer buffer) {
        this.mouse_queue.copyEvents(buffer);
    }

    public synchronized void pollMouse(IntBuffer coord_buffer, ByteBuffer buttons) {
        this.mouse_queue.poll(coord_buffer, buttons);
    }

    public synchronized void readKeyboard(ByteBuffer buffer) {
        this.keyboard_queue.copyEvents(buffer);
    }

    public synchronized void pollKeyboard(ByteBuffer keyDownBuffer) {
        this.keyboard_queue.poll(keyDownBuffer);
    }
}

