#ifndef SPRITE_H
#define SPRITE_H

#include "drawEngine.h"
#include "level.h"

enum CLASSID
{
	SPRITE_CLASSID = 0,
	CHARACTER_CLASSID,
	DOLLAR_CLASSID,
	VAPEN_CLASSID,
	HELT_CLASSID
};

struct vector
{
	float x;
	float y;
};

class Sprite
{
public:
	Sprite(Level *le, DrawEngine *de, int s_index, float x = 1, float y = 1, int i_lives = 1);
	~Sprite();

	vector getPosition(void);
	float getX(void);
	float getY(void);

	virtual void addLives(int num = 1);
	int getLives(void);
	bool isAlive(void);
	virtual void idleUpdate(void);
	virtual bool move(float x, float y);
	int classID;
	void setLevel(Level *newLevel);
    void setPosition(int x, int y);
    int getID(void);
    virtual void update(void);
	void setFart(int speed);
	void setTid(long time);
	bool updateSprite(void);
	int getFart(void);

protected:
	Level *level;
	DrawEngine *draw;
	vector pos;
	int spriteIndex;
	int numLives;
	int delay;
	long sistTid;
	bool updateSprite_var;
	vector retning;
	void doDraw(float x, float y);
	void doErase(float x, float y);

	bool isValidMove(int xpos, int ypos);


};

#endif