#include "prewx.h"
#include "level.h"
#include "hovedperson.h"
#include "dollar.h"
#include "konstanter.h"


#include <stdlib.h>

using namespace std;

 // Teoretisk skal 85% av levelen vre ledig.

Level::Level(DrawEngine *de, int bredde, int hoyde)
{
	tegn = de;
	width = bredde;
	height = hoyde;
	startX = 1;
	startY = 1;
	startX2 = 2;
	startY2 = 2;
	int goal = 0;
	//spiller = 0;
	//spiller2 = 0;
	//int antallspillere = 0;

	level = new char *[width];

	for (int i = 0; i < width; i++)
	{
		level[i] = new char[height];
	}
	createLevel();

	tegn->setMap(level);
}

Level::Level(DrawEngine *de, char **mapdata, int lengde, int hoyde) : tegn(de)
{
	level = mapdata;
	width = lengde;
	height = hoyde;
	
	antallspillere = 0;
	startX = 1;
	startY = 1;
	startX2 = 2;
	startY2 = 2;
	spiller = 0;
	spiller2 = 0;

	for(int u = 0; u < lengde; u++)
	{
		for(int i = 0; i < hoyde; i++)
		{
			if(level[u][i] == TOOL_SPILLER)// || level[u][i] == 4)
			{
				level[u][i] = BLOCK_EMPTY;
				startX = u;
				startY = i;
				antallspillere++;	
			}
			else if(level[u][i] == 4)
			{
				level[u][i] = BLOCK_EMPTY;
				startX2 = u;
				startY2 = i;
				antallspillere++;
			}
		}
	}
	tegn->setMap(level);

}

Level::~Level()
{
	for (int i = 0; i < width; i++)
	{
		delete [] level[i];
	}
	delete [] level;

	for(Iterator_npc = npc.begin(); Iterator_npc != npc.end(); Iterator_npc++)
	{
		delete (*Iterator_npc);
	}
}

void Level::createLevel(void)
{
	for (int x = 0; x < width; x++)
	{
		for (int y = 0; y < height; y++)
		{
			random_number = rand() % 100;
			
			if (x == 0 || x == width - 1 || y == 0 || y == height - 1)
			{
				level[x][y] = BLOCK_FULL;
			}
			else
			{
				if(random_number < BLOKKERING || x < 3 && y < 3)
				{
					level[x][y] = BLOCK_EMPTY;
				}
				else
				{
					level[x][y] = BLOCK_FULL;
				}
			}
		}	
	}
}

void Level::draw(void)
{
	tegn->tegnbakgrunn();

}

void Level::nySpiller(Hovedperson *point, int num)
{
	if(num == 1)
	{		
		spiller = point;
	}
	else if(num == 2)
	{
		spiller2 = point;
	}
	nonPC((Sprite *)point);
}

bool Level::keyPress(char c)
{
	if(spiller->isAlive())
		if(spiller->keyPress(c))
		{
			return true;
		}
	
		if(antallspillere == 2)
		{
			if(spiller2->isAlive())
				if(spiller2->keyPress(c))
				{
					return true;
				}
		}/*

	if(spiller || spiller2)
	{
		if(spiller->keyPress(c) || spiller2->keyPress(c))
		{
			return true;
		}
	}*/
	return false;
}

int Level::update(long time)
{	
	//int x = 0;
	for(Iterator_npc = npc.begin(); Iterator_npc != npc.end();)
	{
		//x++;
		if((*Iterator_npc)->getID() == DOLLAR_CLASSID)
		{
		(*Iterator_npc)->setTid(time);
		if((*Iterator_npc)->updateSprite())
			(*Iterator_npc)->idleUpdate();
		}
		else
		{
			(*Iterator_npc)->idleUpdate();
		}

//		tegn->gotoxy(0,22);
//		cout << "Hva er denne verdien? " << npc.end() << endl;
		/*tegn->gotoxy(40,20+x);
		cout << "CPU: " << (*Iterator_npc)->getLives();*/
		
		if((*Iterator_npc)->isAlive() == false)
		{
			Sprite *spr = *Iterator_npc;
			
			//npc.begin()--;
			delete spr;
		    Iterator_npc = npc.erase(Iterator_npc);
		}
      else
		{
         Iterator_npc++;
		}
			
			
			//(Iterator_npc)--;
	}
	/*	else
		{
			x++;
		}*/
	return true;
}

void Level::lagFiende(int antall, int fart)
{
	int a = antall;

	if(antall == 0)
	{
		for(int u = 0; u < width; u++)
		{
			for(int i = 0; i < height; i++)
			{
				if(level[u][i] == TOOL_FIENDE)
				{
					//wxMessageBox("Fant en fiende!");
					Dollar *krone = new Dollar(this,tegn,SPRITE_ENEMY,(float)u,(float)i);
					krone->setFart(70);
					if(antallspillere >= 2)
					{
						goal = rand()%2+1;
					}
					else 
					{
						goal = 1;
					}

					if(goal == 1)
					{
						krone->addGoal(spiller);
					}
					else if(goal == 2)
					{
						krone->addGoal(spiller2);
					}
					nonPC((Sprite *)krone);
				}
			}
		}
		return;
	}
	
	while (a > 0)
	{
		// Lager en tilfeldig verdi som er innenfor 'muren' i levelen.
		int posx = int((float(rand() % 100) / 100) * (getWidth() - 2) + 1);
		int posy = int((float(rand() % 100) / 100) * (getHeight() - 2) + 1);
		if(level[posx][posy] != BLOCK_FULL)
		{
			Dollar *temp = new Dollar(this,tegn,SPRITE_ENEMY,(float)posx,(float)posy);

			temp->setFart(fart);
			temp->addGoal(spiller);

			nonPC((Sprite *)temp);

			a--;

		}
	}
}

void Level::nonPC(Sprite *s)
{
	npc.push_back(s);
}

int Level::getWidth(void)
{
	return width;
}

int Level::getHeight(void)
{
	return height;
}

void Level::settSpillerReset(int spillernr)
{
	if(spillernr == 1)
	{
		//wxMessageBox(_T("En spiller!"),_T(".."));
		spiller->setPosition(startX, startY);
	}
	if(spillernr == 2)
	{
		//wxMessageBox(_T("To spillere!"),_T(".."));
		spiller2->setPosition(startX2, startY2);
	}
/*	for(Iterator_npc = npc.begin(); Iterator_npc != npc.end(); Iterator_npc++)
	{
		if((*Iterator_npc)->getID() == CHARACTER_CLASSID)
		{
			//if((*Iterator_npc)->
			(*Iterator_npc)->
		}
	}*/
}

int Level::numEnemies(void)
{
	int num = 0;

	for(Iterator_npc = npc.begin(); Iterator_npc != npc.end(); Iterator_npc++)
	{
		if((*Iterator_npc)->getID() == DOLLAR_CLASSID)
		{
			num++;
		}
	}
	return num;
}

void Level::setantallspillere(int nommer)
{
	antallspillere = nommer;
}

int Level::getAntallSpillere(void)
{
	return antallspillere;
}