#ifndef HOVEDVINDU_H
#define HOVEDVINDU_H

#include <list>
#include "prewx.h"
#include "resources.h"
#include "drawEngine.h"
#include "level.h"
#include "vapen.h"
#include "helt.h"
#include "time.h" 

using namespace std;

enum GameState
{
	STATE_NULL = 0,
	STATE_ON,
	STATE_OVER,
	STATE_PAUSE,
	STATE_WIN
};


enum LevelType
{
	TYPE_RANDOM = 0,
	TYPE_LOAD
};

enum ID_List
{
	uID_Ny = 400,
	uID_Last,
	uID_Avslutt,
	uID_Hjelp,
	uID_About,
	uID_Timer,
	uID_Highscore
};

struct map
{
	int x, y;
	char **levelxy;
};

typedef list<map *> Arkiv;

class Hovedvindu : public wxFrame
{
public:
	Hovedvindu(const wxString &tittel, const wxPoint &pos, const wxSize &storrelse, wxString filnavna = "", long levelnummer = 0);
	~Hovedvindu();
	void ID_Ny(wxCommandEvent &event);
	void ID_Last(wxCommandEvent &event);
	void ID_Avslutt(wxCommandEvent &event);
	void ID_Hjelp(wxCommandEvent &event);
	void ID_About(wxCommandEvent &event);
	void ID_Highscore(wxCommandEvent &event);
	void OnTimer(wxTimerEvent &event);
	void OnSize(wxSizeEvent &event);
	void OnPaint(wxPaintEvent &event);
	void OnKey(wxKeyEvent &event);
	

	bool multi;
	void setTotalfienderdrept(int antall);
	

private:
	void Do_Load(wxString filnavna, int levelnummera = 1);
	wxPanel *pa_hoved;
	wxPanel *pa_tekst;

	wxWindow *spillvindu;

	wxStaticText *st_spillerliv;
	wxStaticText *st_spillerliv2;
	wxStaticText *st_fiender;	
	wxStaticText *st_level;
	wxStaticText *st_speed;
	wxTimer *m_timer;
	int Timerlol;
	Level *level;
	Helt *spiller;
	Helt *spiller2;
	Vapen *vapen;
	DrawEngine draw;
	wxBitmap *backBuffer;
	wxBitmap *finalBackBuffer;
	bool startNyLevel(LevelType typeer);
	void updateDraw(void);
	void updateGame(void);
	int enemy_speed;
	int currentLevel;
	int ANTALL_FIENDER;
	GameState gamestate;
	void drawInfo(void);
	void strekkVindu(void);
	void flipBackBuffer(void);
	int var;
	wxImage strekkBilde;
	void LagreHighscore(void);
	void OpenHighscore(void);


	int antiTestHighScore;
	bool levelLastet;
	Arkiv *arkiv;
	int levelsize;
	map *Levelmap;
	int totaltdrept;
	int score;
	wxString highscorelevel;
	time_t rawtime;
	struct tm * timeinfo;
	//struct tm * merkelig;
	bool beat;
	bool once;
	wxString urort;
	int tidligere;

private:

	DECLARE_EVENT_TABLE()
};

#endif