#include "prewx.h"
#include "drawEngine.h"
#include "konstanter.h"


DrawEngine::DrawEngine(int xSize, int ySize)
{
	screenWidth = xSize;
	screenHeight = ySize;
	map = 0;
}

DrawEngine::~DrawEngine()
{

}

int DrawEngine::createSprite(int index, wxBitmap *sprite)
{
	if (index < 10 && index >= 0)
	{
		wxImage img = sprite->ConvertToImage();
		img.SetMaskColour(255,255,255);

		spriteBilde[index] = new wxBitmap(img);
		return index;
	}
	
	return -1;
}

int DrawEngine::deleteSprite(int index)
{
	return 0;
}
							  
void DrawEngine::drawSprite(int index, int posx, int posy)
{
	wxMemoryDC dc;

	dc.SelectObject(*winCanvas);
	dc.DrawBitmap(*spriteBilde[index], wxPoint(posx*IMG_SIZE,posy*IMG_SIZE), true);

	dc.SelectObject(wxNullBitmap);
}

void DrawEngine::lagBakgrunnsBilde(int index, wxBitmap *bakgrunn)
{
	if (index < 5 && index >= 0)
	{
		wxImage img = bakgrunn->ConvertToImage();
		img.SetMaskColour(255,255,255);

		bilder[index] = new wxBitmap(img);
	}
}
void DrawEngine::tegnbakgrunn(void)
{
	wxMemoryDC dc;

	dc.SelectObject(*winCanvas);
	if(map)
	{
		for(int y = 0; y < screenHeight; y++)
		{
			for (int x = 0; x < screenWidth; x++)
			{
				if(map[x][y] < 2)
				{
					dc.DrawBitmap(*bilder[map[x][y]], wxPoint(x*IMG_SIZE,y*IMG_SIZE), true);
				}
			}
		}

	}
	dc.SelectObject(wxNullBitmap);
}

void DrawEngine::setMap(char **info)
{
	map = info;
}
void DrawEngine::eraseSprite(int posx, int posy)
{
	wxMemoryDC dc;

	dc.SelectObject(*winCanvas);
	dc.DrawBitmap(*bilder[0], wxPoint(posx*IMG_SIZE,posy*IMG_SIZE), true);
	//wxMessageBox(_T("6.1"),_T("About"));
	dc.SelectObject(wxNullBitmap);
}

void DrawEngine::SetVindu(wxBitmap *inn, int width, int height)
{
	winCanvas = inn;

	screenWidth = width;
	screenHeight = height;
}