#include "prewx.h"
#include "dollar.h"

#include <stdlib.h>
#include <math.h>


Dollar::Dollar(Level *lvl, DrawEngine *de, int s_index, float x, float y, int i_lives)
				: Sprite(lvl, de, s_index, x, y, i_lives)
{
	goal = 0;
	classID = DOLLAR_CLASSID;
}

bool Dollar::move(float x, float y)
{
	int ypos = (int)(pos.y + y);
	int xpos = (int)(pos.x + x);

	if(isValidMove(xpos, ypos))
	{
		// Gjr at 2 fiender ikke er opp hverandre 
		list <Sprite *>::iterator Iter; 

		for (Iter = level->npc.begin(); Iter != level->npc.end(); Iter++)
		{
			if((*Iter) != this && (*Iter)->classID == this->classID && (int)(*Iter)->getX() == xpos && (int)(*Iter)->getY() == ypos)
			{
				
				return false;
			}
		}
		
		doErase(pos.x,pos.y);
		pos.y += y;
		pos.x += x; 

		retning.x = x;
		retning.y = y;

		
		doDraw(pos.x,pos.y);

		if((int)goal->getX() == xpos && (int)goal->getY() == ypos)
		{
			goal->addLives(-1);
		}
		return true;
	}

	return false;
}

void Dollar::idleUpdate(void)
{
	if (goal)
	{
		CPU();
	}
}

void Dollar::addGoal(Hovedperson *c)
{
	goal = c;
}

void Dollar::CPU(void)
{
	vector spiller_pos = goal->getPosition();
	vector fiende_retning;

	// Hovedpersonen sin posisjon, minus fienden sin = Den veien den m g.
	fiende_retning.x = spiller_pos.x - pos.x;
	fiende_retning.y = spiller_pos.y - pos.y;
	
	// Gjr at fienden ikke flytter seg mer enn et hakk om gangen.
	float storrelse = sqrt(fiende_retning.x * fiende_retning.x + fiende_retning.y * fiende_retning.y);

	fiende_retning.x = fiende_retning.x / (storrelse * 10);
	fiende_retning.y = fiende_retning.y / (storrelse * 10);

	// Bruteforcer seg rundt en mur.
	if(!move(fiende_retning.x, fiende_retning.y))
	{
		while(!move(float((rand() % 3) - 1), float(rand() % 3 - 1)))
		{
		}
	}
}