#include <windows.h>
#include <gl\gl.h>
#include <gl\glu.h>

#include "resource.h"
#include "sstring.h"
#include "fmod.h"

extern void DrawGLScene();
extern void InitScene();
extern void DeInitScene();
extern void ShowStartGraph(HWND);

extern BOOL CALLBACK DP_Start(HWND hdlg, UINT message, WPARAM wparam, LPARAM lparam);
extern void SeparatePath(char *full_name, SString &path, SString &file);
extern void MouseLook(WORD cx_screen, WORD cy_screen, WORD x, WORD y);

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

char *program_directory;

FSOUND_STREAM * music;

HGLRC		hRC = NULL;
HDC			hDC = NULL;
HWND		hWnd = NULL;
HINSTANCE	hInstance;

BOOL		active = TRUE;
BOOL		keys[256];

DWORD scr_cx_res;
DWORD scr_cy_res;
DWORD scr_bpp;
DWORD scr_freq;

float img_cx_scale;
float img_cy_scale;

GLvoid ReSizeGLScene(int width, int height)
{
	glViewport(0, 0, width, height);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(45.0f, (float)width / (float)height, 0.01f, 100.0f);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	SwapBuffers(hDC);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	SwapBuffers(hDC);
}

int InitGL()
{
	glShadeModel(GL_SMOOTH);
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

	glClearDepth(1.0f);
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);

	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);

	InitScene();
	return TRUE;
}

void KillGLWindow()
{
	DeInitScene();

	ChangeDisplaySettings(NULL, 0);
	ShowCursor(TRUE);

	if (hRC)
	{
		wglMakeCurrent(NULL, NULL);
		wglDeleteContext(hRC);
		hRC = NULL;
	}

	if (hDC)
	{
		ReleaseDC(hWnd, hDC);
		hDC = NULL;
	}

	if (hWnd)
	{
		DestroyWindow(hWnd);
		hWnd = NULL;
	}

	UnregisterClass("OpenGL", hInstance);
}

BOOL CreateGLWindow(char * title, int width, int height, int bits, int scr_freq)
{
	GLuint		PixelFormat;
	WNDCLASS	wc;
	DWORD		dwExStyle;
	DWORD		dwStyle;

	RECT		WindowRect;
	WindowRect.left		= (long) 0;
	WindowRect.right	= (long) width;
	WindowRect.top		= (long) 0;
	WindowRect.bottom	= (long) height;

	hInstance	= GetModuleHandle(NULL);

	wc.style	= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc	= (WNDPROC) WndProc;
	wc.cbClsExtra	= 0;
	wc.cbWndExtra	= 0;
	wc.hInstance	= hInstance;
	wc.hIcon		= LoadIcon(NULL, IDI_WINLOGO);
	wc.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground= NULL;
	wc.lpszMenuName = NULL;
	wc.lpszClassName= "OpenGL";


	if (!RegisterClass(&wc))
	{
		MessageBox(NULL, "Falied To Register Window Class",	"ERROR", MB_OK);
		return FALSE;
	}

	DEVMODE dmScreenSettings;
	memset(&dmScreenSettings, 0, sizeof(dmScreenSettings));
	dmScreenSettings.dmSize			= sizeof(dmScreenSettings);
	dmScreenSettings.dmPelsWidth	= width;
	dmScreenSettings.dmPelsHeight	= height;
	dmScreenSettings.dmBitsPerPel	= bits;
	dmScreenSettings.dmDisplayFrequency = scr_freq;
	dmScreenSettings.dmFields = DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT/* |DM_DISPLAYFREQUENCY*/;

	if (ChangeDisplaySettings(&dmScreenSettings,
		CDS_FULLSCREEN) != DISP_CHANGE_SUCCESSFUL)
	{
		MessageBox(NULL, "Unable To Run In Fullscreen!", "ERROR", MB_OK);
		MessageBox(NULL, "Program Will Now Quit", "ERROR", MB_OK);
		return FALSE;
	}

	dwExStyle	= WS_EX_APPWINDOW;
	dwStyle		= WS_POPUP;
	ShowCursor(FALSE);

	AdjustWindowRectEx(&WindowRect, dwStyle, FALSE, dwExStyle);

	if (!(hWnd = CreateWindowEx(dwExStyle,
		"OpenGL",
		title,
		WS_CLIPSIBLINGS |
		WS_CLIPCHILDREN |
		dwStyle,
		0, 0,
		WindowRect.right - WindowRect.left,
		WindowRect.bottom - WindowRect.top,
		NULL,
		NULL,
		hInstance,
		NULL)))
	{
		KillGLWindow();
		MessageBox(NULL, "Window Creation Error.", "ERROR", MB_OK);
		return FALSE;
	}

	static PIXELFORMATDESCRIPTOR pfd = 
	{
		sizeof (PIXELFORMATDESCRIPTOR),
			1,
			PFD_DRAW_TO_WINDOW |
			PFD_SUPPORT_OPENGL |
			PFD_DOUBLEBUFFER,
			PFD_TYPE_RGBA,
			bits,
			0, 0, 0, 0, 0, 0,
			0,
			0,
			0,
			0, 0, 0, 0,
			16,
			0,
			0,
			PFD_MAIN_PLANE,
			0,
			0, 0, 0
	};

	if (!(hDC = GetDC(hWnd)))
	{
		KillGLWindow();
		MessageBox(NULL, "Can`t Create A GL Device Context",
			"ERROR", MB_OK);
		return FALSE;
	}

	if (!(PixelFormat = ChoosePixelFormat(hDC, &pfd)))
	{
		KillGLWindow();
		MessageBox(NULL, "Can`t Find A Suitable PixelFormat",
			"ERROR", MB_OK);
		return FALSE;
	}

	if (!SetPixelFormat(hDC, PixelFormat, &pfd))
	{
		KillGLWindow();
		MessageBox(NULL, "Can`t Set The PixelFormat",
			"ERROR", MB_OK);
		return FALSE;
	}

	if (!(hRC = wglCreateContext(hDC)))
	{
		KillGLWindow();
		MessageBox(NULL, "Can`t Create A GL Rendering Context",
			"ERROR", MB_OK);
		return FALSE;
	}

	if (!wglMakeCurrent(hDC, hRC))
	{
		KillGLWindow();
		MessageBox(NULL, "Can`t Activate The GL Rendering Context",
			"ERROR", MB_OK);
		return FALSE;
	}

	ShowWindow(hWnd, SW_SHOW);
	SetForegroundWindow(hWnd);
	SetFocus(hWnd);
	ReSizeGLScene(width, height);

	ShowStartGraph(hWnd);

	if (!InitGL())
	{
		KillGLWindow();
		MessageBox(NULL, "Initialization Falied",
			"ERROR", MB_OK);
		return FALSE;
	}

	return TRUE;
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
	case WM_ACTIVATE:
		if (!HIWORD (wParam))
		{
			active = TRUE;
		}
		else
		{
			active = FALSE;
		}

		return 0;

	case WM_SYSCOMMAND:
		switch (wParam)
		{
		case SC_SCREENSAVE:
		case SC_MONITORPOWER:
			return 0;
		}
		break;

	case WM_CLOSE:
		PostQuitMessage(0);
		return 0;

	case WM_KEYDOWN:
		keys[wParam] = TRUE;
		return 0;

	case WM_KEYUP:
		keys[wParam] = FALSE;
		return 0;

	case WM_SIZE:
		ReSizeGLScene(LOWORD (lParam), HIWORD (lParam));
		return 0;

	case WM_MOUSEMOVE:
		MouseLook(800, 600, LOWORD(lParam), HIWORD(lParam));
		return 0;
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE, LPSTR, int)
{
	char full_name[2048];
	GetModuleFileName(NULL, full_name, 2048);
	SString path, file;
	SeparatePath(full_name, path, file);
	program_directory = new char[path.getLength() + 1];
	strcpy(program_directory, path);

	MSG		msg;
	BOOL	done = FALSE;

	FSOUND_Init(44000, 22, 0);
	music = FSOUND_Stream_Open("data/msx/msx.mp3", 0, 0, 0);

	if (DialogBox(hInstance, MAKEINTRESOURCE(IDD_START), hWnd, DP_Start))
	{
		img_cx_scale = (float)scr_cx_res / 1024.0f;
		img_cy_scale = (float)scr_cy_res / 768.0f;

		if (!CreateGLWindow("OpenGL", scr_cx_res, scr_cy_res, scr_bpp, scr_freq))
		{
			return 0;
		}

		while (!done)
		{
			if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
			{
				if (msg.message == WM_QUIT)
				{
					done = TRUE;
				}
				else
				{
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
			}
			else
			{
				if (active)
				{
					if (keys[VK_ESCAPE])
					{
						done = TRUE;
					}
					else
					{
						DrawGLScene();
						SwapBuffers(hDC);
					}
				}
			}
		}
	}

	FSOUND_Stream_Stop(music);
	FSOUND_Stream_Close(music);
	FSOUND_Close();

	KillGLWindow();
	return (int)(msg.wParam);
}
