#include "HermiteSpline.h"

HERMITESPLINE::HERMITESPLINE()
{
	c_keys = 0;
	frames = NULL;
	position = NULL;
}

HERMITESPLINE::~HERMITESPLINE()
{
	Release();
}

void HERMITESPLINE::Release()
{
	if (frames)
	{
		delete [] frames;
		frames = NULL;
	}

	if (position)
	{
		delete [] position;
		position = NULL;
	}

	c_keys = 0;
}

void HERMITESPLINE::Get4Keys(DWORD frame, DWORD *k1, DWORD *k2, DWORD *k3, DWORD *k4)
{
	*k1 = 0xFFFFFFFF;
	*k2 = 0xFFFFFFFF;
	*k3 = 0;
	*k4 = 0xFFFFFFFF;

	//frame jest za maly niz pierszy frame
	if (frame < frames[0])
	{
		*k3 = 0;
		return;
	}

	//frame przekroczyl max ilosc klatek
	if (frame > frames[c_keys-1])
	{
		*k3 = c_keys-1;
		return;
	}

	while (frames[(*k3)] < frame) (*k3)++;

	if (frames[(*k3)] == frame) return;
	if ((*k3) >= 1) (*k2) = (*k3) - 1; else *k2 = 0xFFFFFFFF;
	if ((*k3) >= 2) (*k1) = (*k3) - 2; else *k1 = 0xFFFFFFFF;
	if (((*k3) + 1) <= c_keys - 1) (*k4) = (*k3) + 1; else *k4 = 0xFFFFFFFF;
}

void HERMITESPLINE::GetPositionOnFrame(DWORD frame, G3DVECTOR *position)
{	
	DWORD k1, k2, k3, k4;
	float t;
	G3DVECTOR v2, v3;

	Get4Keys(frame, &k1, &k2, &k3, &k4);

	//on frame
	if (k1 == 0xFFFFFFFF && k2 == 0xFFFFFFFF && k4 == 0xFFFFFFFF)
	{
		*position = this ->position[k3];
		return;
	}

	//in
	if (k1 != 0xFFFFFFFF && k2 != 0xFFFFFFFF && k4 != 0xFFFFFFFF)
	{
		v2 = this ->position[k3] - this ->position[k1];
		v2 = v2 * 0.5f;

		v3 = this ->position[k4] - this ->position[k2];
		v3 = v3 * 0.5f;
	}

	//start
	if (k1 == 0xFFFFFFFF && k2 != 0xFFFFFFFF && k4 != 0xFFFFFFFF)
	{
		v3 = this ->position[k4] - this ->position[k2];
		v3 = v3 * 0.5f;

		v2 = this ->position[k3] - this ->position[k2];
		v2 = v2 * 1.5f;
		v2 = v2 - v3*0.5f;
	}

	//end
	if (k1 != 0xFFFFFFFF && k2 != 0xFFFFFFFF && k4 == 0xFFFFFFFF)
	{
		v2 = this ->position[k3] - this ->position[k1];
		v2 = v2 * 0.5f;

		v3 = this ->position[k3] - this ->position[k2];
		v3 = v3 * 1.5f;
		v3 = v3 - v2 * 0.5f;
	}

	//only 2 keys
	if (k1 == 0xFFFFFFFF && k2 != 0xFFFFFFFF && k4 == 0xFFFFFFFF)
	{
		v2 = this ->position[k3] - this ->position[k2];
		v3 = v2;
	}

	t = (float) (frame - frames[k2]) / (float) (frames[k3] - frames[k2]);

	*position = this ->position[k2] * (2*t*t*t - 3*t*t + 1) +
				v2 * (t*t*t - 2*t*t + t) +
				this ->position[k3] * (-2*t*t*t + 3*t*t) +
				v3 * (t*t*t - t*t);
}

void HERMITESPLINE::CreateKeys(DWORD c_keys)
{
	this ->c_keys = c_keys;
	position = new G3DVECTOR[c_keys];
	frames = new DWORD[c_keys];
}

void HERMITESPLINE::SetKey(DWORD key, G3DVECTOR position, DWORD frame)
{
	this ->position[key] = position;
	this ->frames[key] = frame;
}

void HERMITESPLINE::SetKey(DWORD key, float x, float y, float z, DWORD frame)
{
	G3DVECTOR	vec;
	vec(x, y, z);
	SetKey(key, vec, frame);
}

DWORD HERMITESPLINE::GetLastFrame()
{
	return frames[c_keys - 1];
}