//Coded by asmCode 19:31 03-08-31

#ifndef _G3DVECTOR_
#define _G3DVECTOR_

#define rad(x) (float) ((3.141592654f * x) / 180.0f)
#define deg(x) (float) ((180.0f * x) / 3.141592654f)

#include <windows.h>
#include <math.h>

struct G3DVECTOR
{
public:
	float	x;
	float	y;
	float	z;

	G3DVECTOR();
	G3DVECTOR(float x, float y, float z);

	void		Reset();
	void		RotateY(float angle);
	void		RotateX(float angle);
	void		RotateZ(float angle);
	void		CrossProductFrom3Points(G3DVECTOR p1, G3DVECTOR p2, G3DVECTOR p3);
	G3DVECTOR	operator * (G3DVECTOR source_vector);
	G3DVECTOR	operator * (float source_number);
	G3DVECTOR	operator - (G3DVECTOR source_vector);
	G3DVECTOR	operator + (G3DVECTOR source_vector);
	BOOL		operator ==(G3DVECTOR source_vector);
	void		operator ()(float _x, float _y, float _z);
	float		DotProduct(G3DVECTOR source_vector);
	float		VectorLength();
	float		GetAngle(G3DVECTOR source_vector);
	void		Normalize();
	void		Reverse();
	void		SetVectorLength(float length);
};

#endif