#pragma once

#include <windows.h>
#include <gl/gl.h>

#include "g3dvector.h"
#include "quat.h"

class aAnimKey
{
public:
	DWORD		frame;

	G3DVECTOR	pos;
	QUAT		rotate;
	G3DVECTOR	scale;
};

class aAnim
{
private:
	DWORD		c_keys;
	aAnimKey	*keys;

	void		get4Keys(DWORD frame, DWORD *ret_keys);
	void		getPositionOnFrame(float time, DWORD *ret_keys, G3DVECTOR *position);
	void		getRotateOnFrame(float time, DWORD *ret_keys, QUAT *rotate);
	void		getScaleOnFrame(float time, DWORD *ret_keys, G3DVECTOR *scale);

public:
	aAnim(void);
	~aAnim(void);

	void		createKeySlots(DWORD key_index, DWORD c_keys);
	void		deleteKeySlots(DWORD key_index, DWORD c_keys);
	void		setKey(DWORD key_index, DWORD frame, G3DVECTOR *pos, QUAT *rotate, G3DVECTOR *scale);
	void		setKey(DWORD key_index, DWORD frame, G3DVECTOR *pos, G3DVECTOR *axis, float *angle, G3DVECTOR *scale);

	void		getDataOnFrame(DWORD frame, G3DVECTOR *pos, QUAT *rotate, G3DVECTOR *scale);
	void		getDataOnFrame(DWORD frame, G3DVECTOR *pos, G3DVECTOR *axis, float *angle, G3DVECTOR *scale);
	DWORD		getLastFrame();
	DWORD		getKeysAmount();

	void		setMatrixOnFrame(DWORD frame, BYTE mask);

	aAnimKey	*getKeyData(DWORD key);

	enum
	{
		ANIM_ALL	= 0x0,
		ANIM_MOVE	= 0x1,
		ANIM_ROTATE	= 0x2,
		ANIM_SCALE	= 0x4
	};
};