#include "sstring.h"

SString::SString(void)
{
	text = new char[1];
}

SString::SString(char *s)
{
	text = new char[strlen(s) + 1];
	strcpy(text, s);
}

SString::SString(SString &s)
{
	text = new char[strlen(s.text) + 1];
	strcpy(text, s);
}

SString::~SString(void)
{
	delete [] text;
}

bool SString::operator == (char *c)
{
	if (strcmp(text, c) != 0) return false;
	return true;
}

bool SString::operator == (SString &s)
{
	return ((*this) == s.text);
}

SString & SString::operator =(char *c)
{
	delete [] text;
	text = new char[strlen(c) + 1];
	strcpy(text, c);

	return (*this);
}

SString & SString::operator =(SString &s)
{
	return ((*this) = s.text);
}

SString SString::operator +(char *c)
{
	SString ret_val;

	ret_val.text = new char[strlen(text) + strlen(c) + 1];
	ret_val.text[0] = 0;
	strcat(ret_val.text, text);
	strcat(ret_val.text, c);

	return ret_val;
}

SString SString::operator +(SString &s)
{
	return ((*this) + s.text);
}

SString SString::operator +(char c)
{
	char v[] = {c, 0};
	return ((*this) + v);
}

SString & SString::operator +=(char *c)
{
	return ((*this) = (*this) + c);
}

SString & SString::operator +=(SString &s)
{
	return ((*this) = (*this) + s.text);
}

SString & SString::operator +=(char c)
{
	char v[] = {c, 0};
	return ((*this) = (*this) + v);
}

SString::operator char *()
{
	char *ret_val = new char[strlen(text) + 1];
	strcpy(ret_val, text);
	return ret_val;
}

int SString::getLength()
{
	return strlen(text);
}