#define SHADOW_EPSILLON 0.00005f

texture g_txDiffuseMap;

sampler DiffuseMapSampler = sampler_state
{
    Texture   = (g_txDiffuseMap);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

texture g_txShadowMap;

sampler ShadowMapSampler = sampler_state
{
	Texture	=  (g_txShadowMap);
	MipFilter=POINT;
	MinFilter=POINT;
	MagFilter=POINT;
	AddressU=Clamp;
	AddressV=Clamp;
};

float4x4 g_mWorldView;
float4x4 g_mProj;
float4x4 g_mViewToLightProj;

float3 g_vViewSpaceLightPosition;
float3 g_vViewSpaceLightDirection;

float g_fCosLightOuterAngle;
float g_fCosLightInnerAngle;
float g_fCosLightAngleDelta;


void ShadowMapVS(	float4 Position : POSITION, 
					out float4 oPosition : POSITION, 
					out float2 oDepth :	TEXCOORD0)
{
	oPosition=mul(Position, g_mWorldView);
	oPosition=mul(oPosition, g_mProj);
	
	oDepth.xy=oPosition.zw;
}

void ShadowMapPS(float2 Depth : TEXCOORD0, 
					out float4 oColour : COLOR)
{
	oColour=Depth.x/Depth.y;
}

technique ShadowMap
{
	pass P0
	{
		VertexShader = compile vs_1_1 ShadowMapVS();
		PixelShader = compile ps_2_0 ShadowMapPS();
	}
}

void SceneVS(	float4 Position : POSITION,
                float3 Normal : NORMAL,
                float2 TexUV : TEXCOORD0,
                out float4 oPosition : POSITION,
                out float2 oTexUV : TEXCOORD0,
                out float4 oViewSpacePosition : TEXCOORD1,
                out float3 oViewSpaceNormal : TEXCOORD2,
                out float4 oLightProjectionSpacePosition : TEXCOORD3 )
{
    oViewSpacePosition = mul( Position, g_mWorldView );
    oPosition = mul( oViewSpacePosition, g_mProj );
    oViewSpaceNormal = mul( Normal, (float3x3)g_mWorldView );
    oTexUV = TexUV;
    oLightProjectionSpacePosition = mul( oViewSpacePosition, g_mViewToLightProj );
}

float g_fShadowMapSize;
float g_fRecipShadowMapSize;

//single shadow lookup only
//float4 ScenePS(	float2 TexUV : TEXCOORD0,
//				float4 ViewSpacePosition : TEXCOORD1,
//				float3 ViewSpaceNormal : TEXCOORD2,
//				float4 LightProjectionSpacePosition : TEXCOORD3) : COLOR
//{
//	float2 ShadowTexC=(0.5f*LightProjectionSpacePosition.xy/LightProjectionSpacePosition.w)+float2(0.5, 0.5);
//	ShadowTexC.y=1.f-ShadowTexC.y;
	
//	float Shadow=(tex2D(ShadowMapSampler, ShadowTexC) + SHADOW_EPSILLON) < (LightProjectionSpacePosition.z/LightProjectionSpacePosition.w) ? 0.5f : 1.f;
	
//	return tex2D(DiffuseMapSampler, TexUV)*Shadow;
//}

//PCF shadow lookup
//float4 ScenePS(	float2 TexUV : TEXCOORD0,
//				float4 ViewSpacePosition : TEXCOORD1,
//				float3 ViewSpaceNormal : TEXCOORD2,
//				float4 LightProjectionSpacePosition : TEXCOORD3) : COLOR
//{
//	float2 ShadowTexC=(0.5f*LightProjectionSpacePosition.xy/LightProjectionSpacePosition.w)+float2(0.5, 0.5);
//	ShadowTexC.y=1.f-ShadowTexC.y;
//	
//	float2 TexelPos=ShadowTexC*g_fShadowMapSize;
//	float2 Lerps=frac(TexelPos);
//	
//	float Vals[4];
//	Vals[0]=(tex2D(ShadowMapSampler, ShadowTexC) + SHADOW_EPSILLON) < (LightProjectionSpacePosition.z/LightProjectionSpacePosition.w) ? 0.25f : 1.f;
//	Vals[1]=(tex2D(ShadowMapSampler, ShadowTexC + float2(1.f/g_fShadowMapSize, 0) ) + SHADOW_EPSILLON) < (LightProjectionSpacePosition.z/LightProjectionSpacePosition.w) ? 0.25f : 1.f;
//	Vals[2]=(tex2D(ShadowMapSampler, ShadowTexC + float2(0, 1.f/g_fShadowMapSize) ) + SHADOW_EPSILLON) < (LightProjectionSpacePosition.z/LightProjectionSpacePosition.w) ? 0.25f : 1.f;
//	Vals[3]=(tex2D(ShadowMapSampler, ShadowTexC + float2(1.f/g_fShadowMapSize, 1.f/g_fShadowMapSize)) + SHADOW_EPSILLON) < (LightProjectionSpacePosition.z/LightProjectionSpacePosition.w) ? 0.25f : 1.f;
//	
//	float Shadow=lerp(lerp(Vals[0], Vals[1], Lerps.x), lerp(Vals[2], Vals[3], Lerps.x), Lerps.y);
//	
//	return tex2D(DiffuseMapSampler, TexUV)*Shadow;
//}

//just phong in viewspace
//float4 ScenePS(float2 TexUV : TEXCOORD0, float4 ViewSpacePosition : TEXCOORD1, float3 ViewSpaceNormal: TEXCOORD2, float4 LightProjectionSpacePosition : TEXCOORD3) : COLOR
//{
//	float3 vLight=-normalize(ViewSpacePosition-g_vViewSpaceLightPosition); //direction to light in view space
//	float3 vView=normalize(-ViewSpacePosition);
//	
//	float fDiffuseCoeff=dot(vLight, ViewSpaceNormal);
//	float fSpecularCoeff=0;
//	
//	if(dot(-vLight, g_vViewSpaceLightDirection) < g_fCosLightAngle) {
//		fDiffuseCoeff*=0.5f;
//	} else {
//		//fDiffuseCoeff*=2.f;
//		float3 vReflection=normalize(2.f*saturate(dot(vLight, ViewSpaceNormal))*ViewSpaceNormal - (vLight) );
//		fSpecularCoeff=pow(saturate(dot(vReflection, vView)), 15);
//	}
//
//	return tex2D(DiffuseMapSampler, TexUV)*fDiffuseCoeff + float4(1.f, 1.f, 1.f, 1.f)*fSpecularCoeff;
//}

//pcff shadows and phong
//float4 ScenePS(float2 TexUV : TEXCOORD0, float4 ViewSpacePosition : TEXCOORD1, float3 ViewSpaceNormal: TEXCOORD2, float4 LightProjectionSpacePosition : TEXCOORD3) : COLOR
//{
//	float3 vLight=-normalize(ViewSpacePosition-g_vViewSpaceLightPosition); //direction to light in view space
//	float3 vView=normalize(-ViewSpacePosition);
	
//	float fDiffuseCoeff=dot(vLight, ViewSpaceNormal);
//	float fSpecularCoeff=0;
	
//	if(dot(-vLight, g_vViewSpaceLightDirection) < g_fCosLightOuterAngle) {
//		fDiffuseCoeff*=0.3f;
//	} else {
//		//specular
//		float3 vReflection=normalize(2.f*saturate(dot(vLight, ViewSpaceNormal))*ViewSpaceNormal - (vLight) );
//		fSpecularCoeff=pow(saturate(dot(vReflection, vView)), 15);
		
//		//shadow term
//		float2 ShadowTexC=(0.5f*LightProjectionSpacePosition.xy/LightProjectionSpacePosition.w)+float2(0.5, 0.5);
//		ShadowTexC.y=1.f-ShadowTexC.y;
		
//		float2 TexelPos=ShadowTexC*g_fShadowMapSize;
//		float2 Lerps=frac(TexelPos);
		
//		float Vals[4];
//		Vals[0]=(tex2D(ShadowMapSampler, ShadowTexC) + SHADOW_EPSILLON) < (LightProjectionSpacePosition.z/LightProjectionSpacePosition.w) ? 0.25f : 1.f;
//		Vals[1]=(tex2D(ShadowMapSampler, ShadowTexC + float2(1.f/g_fShadowMapSize, 0) ) + SHADOW_EPSILLON) < (LightProjectionSpacePosition.z/LightProjectionSpacePosition.w) ? 0.25f : 1.f;
//		Vals[2]=(tex2D(ShadowMapSampler, ShadowTexC + float2(0, 1.f/g_fShadowMapSize) ) + SHADOW_EPSILLON) < (LightProjectionSpacePosition.z/LightProjectionSpacePosition.w) ? 0.25f : 1.f;
//		Vals[3]=(tex2D(ShadowMapSampler, ShadowTexC + float2(1.f/g_fShadowMapSize, 1.f/g_fShadowMapSize)) + SHADOW_EPSILLON) < (LightProjectionSpacePosition.z/LightProjectionSpacePosition.w) ? 0.25f : 1.f;
		
//		float fShadow=lerp(lerp(Vals[0], Vals[1], Lerps.x), lerp(Vals[2], Vals[3], Lerps.x), Lerps.y);
		
//		fDiffuseCoeff*=(0.3f+0.7f*fShadow);
//		fSpecularCoeff*=(0.3f+0.7f*fShadow);
//	}

//	return tex2D(DiffuseMapSampler, TexUV)*fDiffuseCoeff + float4(1.f, 1.f, 1.f, 1.f)*fSpecularCoeff;
//}

//size optimized and with falloff
float4 ScenePS(float2 TexUV : TEXCOORD0, float4 ViewSpacePosition : TEXCOORD1, float3 ViewSpaceNormal: TEXCOORD2, float4 LightProjectionSpacePosition : TEXCOORD3) : COLOR
{
	float3 vLight=-normalize(ViewSpacePosition-g_vViewSpaceLightPosition); //direction to light in view space
	float3 vView=normalize(-ViewSpacePosition);
	
	float2 fCoeff=float2(dot(vLight, ViewSpaceNormal), 0); //x=diffuse, y=specular
	
	float fPixelDotLightDirection=dot(-vLight, g_vViewSpaceLightDirection);
	
	if(fPixelDotLightDirection < g_fCosLightOuterAngle) {
		fCoeff.x*=0.3f;
	} else {
		//specular
		float3 vReflection=normalize(2.f*saturate(dot(vLight, ViewSpaceNormal))*ViewSpaceNormal - vLight );
		fCoeff.y=pow(saturate(dot(vReflection, vView)), 15);
		
		//shadow term
		float2 ShadowTexC=(0.5f*LightProjectionSpacePosition.xy/LightProjectionSpacePosition.w)+float2(0.5, 0.5);
		ShadowTexC.y=1.f-ShadowTexC.y;
		
		float2 Lerps=frac(ShadowTexC*g_fShadowMapSize);
		
		float fLightProjectionSpacePixelDepth=(LightProjectionSpacePosition.z/LightProjectionSpacePosition.w) - SHADOW_EPSILLON;

	//	float Vals[4];
		float4 vVals;
		float4 vShadowMapLookup;
		vShadowMapLookup.x=tex2D(ShadowMapSampler, ShadowTexC);
		vShadowMapLookup.y=tex2D(ShadowMapSampler, ShadowTexC + float2(g_fRecipShadowMapSize, 0) );
		vShadowMapLookup.z=tex2D(ShadowMapSampler, ShadowTexC + float2(0, g_fRecipShadowMapSize) );
		vShadowMapLookup.w=tex2D(ShadowMapSampler, ShadowTexC + float2(g_fRecipShadowMapSize, g_fRecipShadowMapSize));

		vVals = vShadowMapLookup < fLightProjectionSpacePixelDepth ? 0.25f : 1.f;

		float fShadow=lerp(lerp(vVals.x, vVals.y, Lerps.x), lerp(vVals.z, vVals.w, Lerps.x), Lerps.y);
		
		//falloff
		if(fPixelDotLightDirection < g_fCosLightInnerAngle)
		{
			float fIntensity=(fPixelDotLightDirection-g_fCosLightOuterAngle)/g_fCosLightAngleDelta;
		
			fShadow*=fIntensity;
		}

		fCoeff*=(0.3f+0.7f*fShadow);
	}

	return tex2D(DiffuseMapSampler, TexUV)*fCoeff.x + float4(1.f, 1.f, 1.f, 1.f)*fCoeff.y;
}

technique Scene
{
	pass P0
	{
		VertexShader = compile vs_1_1 SceneVS();
		PixelShader = compile ps_2_0 ScenePS();
	}
}


//struct VS_OUTPUT
//{
//	float4 Pos : POSITION;
//	float3 Norm : TEXCOORD0;
//	float2 TexUV : TEXCOORD1;
//	float3 WorldSpacePos : TEXCOORD2;
//};

//VS_OUTPUT PhongSpotlightVS(float3 Pos : POSITION, float2 UV : TEXCOORD0, float3 Norm : NORMAL)
//{
//	VS_OUTPUT Out=(VS_OUTPUT)0;
//	
//	Out.Pos=mul(float4(Pos, 1), FullMatrix);
//	Out.Norm=mul(Norm, (float3x3)WorldMatrix);
//	Out.TexUV=UV;
//	Out.WorldSpacePos=mul(float4(Pos, 1), WorldMatrix);
//
//	return Out;
//}

//float4 PhongSpotlightPS(float3 Norm : TEXCOORD0, float2 TexUV : TEXCOORD1, float3 WorldSpacePos: TEXCOORD2) : COLOR
//{
//	float3 A=normalize(WorldSpacePos-LightPosition);
//	float3 B=normalize(LightTarget-LightPosition);
//	
//	float3 Light=-A;
//	float3 View=normalize(EyePosition-WorldSpacePos);
//	
//	float DiffuseCoeff=dot(Light, Norm), SpecularCoeff=0;
//	if(dot(A, B)<CosLightAngle)
//	{
//		DiffuseCoeff*=0.5f;
//	}
//	else
//	{
//		float3 Reflection=normalize(2.f*saturate(dot(Light, Norm))*Norm - Light);
//		SpecularCoeff=pow(saturate(dot(Reflection, View)), 15);
//	}
//	
//	return DiffuseCoeff*tex2D(DiffuseSampler, TexUV)*DiffuseColour + SpecularCoeff*(1, 1, 1, 1);
//}

//technique PhongSpotlight
//{
//	pass P0
//	{
//		VertexShader = compile vs_2_0 PhongSpotlightVS();
//		PixelShader = compile ps_2_0 PhongSpotlightPS();
//	}
//}
