varying vec3 normal; // vertexnormal

void main()
{
    normal = normalize(gl_NormalMatrix * gl_Normal);
    gl_FrontColor = gl_Color; 
    // texture
    gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;
    // normalmap
    gl_TexCoord[1] = gl_TextureMatrix[1] * gl_MultiTexCoord1;
    // glossmap
    gl_TexCoord[2] = gl_TextureMatrix[2] * gl_MultiTexCoord2;
    // envmap - will be generated
    vec4 ecPosition = gl_ModelViewMatrix * gl_Vertex;
    vec3 ecPosition3 = (vec3(ecPosition)) / ecPosition.w;
    vec3 u = normalize(ecPosition3);
    vec3 r = reflect(u, normal);
    float m = 2.0 * sqrt(r.x * r.x + r.y * r.y + (r.z + 1.0) * (r.z + 1.0));
    gl_TexCoord[3].xy = vec2(r.x / m + 0.5, r.y / m + 0.5);
    
    // position
    gl_Position     = ftransform();

}


