varying vec3 normal;

uniform sampler2D tex0, tex1, tex2, tex3;
uniform float tex0amt, tex1amt, tex2amt, tex3amt;

void DirectionalLight(  int i,
                        in vec3 nnormal,
                        inout vec4 amb,
                        inout vec4 diff,
                        inout vec4 spec)
{
        float nDotVP = max(0.0, dot(nnormal,
                        normalize(vec3(gl_LightSource[0].position))));
        float nDotHV = max(0.0, dot(nnormal,
                        normalize(vec3(gl_LightSource[0].halfVector))));
        float pf;

        if((nDotVP == 0.0) || (gl_FrontMaterial.shininess == 0.0)) // if NO shininess, pow function goes haywire :(
                pf = 0.0;
        else
//                pf = pow(nDotHV, 99);
                pf = pow(nDotHV, gl_FrontMaterial.shininess);

        amb += gl_LightSource[0].ambient;
        diff += gl_LightSource[0].diffuse * nDotVP;
        spec += gl_LightSource[0].specular * pf;

}


void main()
{
    
    // base color consist of glColor interpolated with texture0
    // depending on texture_amount
    
    
    // upon this, we add bumpmap

    // and then we add envmaps

    // and then lights and specular maps
    
    vec3 nnormal = normalize(normal);
//    vec3 nnormal = normal * gl_NormalScale;
    

    // pixelcolor is given by base color with texture blitted on top of it
    vec4 pixelcolor = mix(gl_Color, texture2D(tex0, gl_TexCoord[0].st), gl_TexCoord[0].q*tex0amt); 
   
    pixelcolor = mix(pixelcolor, texture2D(tex3, gl_TexCoord[3].st), gl_TexCoord[3].q*tex3amt);

    vec4 ambient = vec4(0.0);
    vec4 specular = vec4(0.0);
    vec4 diffuse = vec4(0.0);
     
    // support light 0 for now. Sigh.
    DirectionalLight(0, nnormal, ambient, diffuse, specular);

    // calculate light
    ambient *= pixelcolor;
    diffuse *= pixelcolor;
    specular *= gl_FrontMaterial.specular;

    // glossmap
    vec4 glosstexel = texture2D(tex2, gl_TexCoord[0].st);
    specular = mix(specular, specular * glosstexel, glosstexel.a*tex2amt);;

    gl_FragColor =  ambient + diffuse + specular;
    gl_FragColor.a = gl_Color.a;


}

