; Industrial Rotozoomer Intro: Nrrr-ka-rrrk
; by gasman / hooy-program

			org 0x8000
			out (254),a	; hope that a is 0 at this point

; make sinewave
stack_a		equ 0x2d28
fp_to_a		equ 0x2dd5

			ld a,64
			call stack_a
			rst 0x28
			db 0xc4	;store 64 into mem 4
			db 0xa3	;push half-pi
			db 0x01	;exchange
			db 0x05	;divide (-> pi/128)
			db 0xc3 ;store pi/128 into mem 3
;			db 0x02	;discard it	(nice but unnecessary?)
			db 0xa0 ;push 0
			db 0x38	;return

			ld hl,sine
sinelp
			push hl

			rst 0x28
			db 0xe3	;recall pi/128
			db 0x0f	;add
			db 0x31	;duplicate
			db 0x1f	;sine
			db 0xe4	;recall 64 from mem 4
;			db 0xa1	;push 1
;			db 0x03	;subtract 1 to give 63
			db 0x04	;multiply
			db 0xe4	;recall 64 again
			db 0x0f ;add again
			db 0x38	;return
			call fp_to_a
			sub 64

			pop hl
			ld (hl),a
			inc l
			jr nz,sinelp

; fill screen with crud
			ld b,0x19
			ld h,b
			ld d,0x3f
			; could fudge b and d to save one byte
			ldir
			
; set up AY
			ld hl,ay_vals
			ld d,13
setup_ay
			ld bc,0xfffd
			out (c),d
			ld a,(hl)
			inc hl
			ld b,0xbf
			out (c),a
			dec d
			jr nz,setup_ay
	
main_lp
			halt
; trigger drum
drumctr		ld a,1
			rrca
			ld (drumctr+1),a
			jr nc,nodrumctr
			ld a,7
			ld bc,0xfffd
			out (c),a
			ld b,0xbf
drumcycle
			ld a,%00100101
			rlca
			ld (drumcycle+1),a
			ld a,%00111110
			jr nc,no_drum
			ld a,32
			ld (skew+1),a
			ld a,%00101110
no_drum
			out (c),a
			ld b,0xff
			ld a,11
			out (c),a
			ld b,0xbf
btptr		ld hl,basstones+7
			ld a,(hl)
			out (c),a
			dec l
			set 3,l
			ld (btptr+1),hl
nodrumctr
			
; plotter
upos		ld hl,0				; x coord of texture
			exx

vpos		ld hl,0
;			push hl				; for 'move texture' bit
			exx

			ld ix,0x5800		; screen address
			ld c,24				; repeat for 24 lines
scrn
			ld b,32				; repeat for 32 cells per line

			push hl				; remember initial upos
ustepx		ld de,0x0030		; amount x coord of texture should change
								; for one step in the x direction on screen
			exx
			push hl				; remember initial vpos
vstepx		ld de,0x000c		; amount y coord of texture should change
								; for one step in the x direction on screen
			exx
row
			add hl,de			; increment upos by ustepx
			ld a,h
			and 0x3f			; keep final lookup value under 0x3fff
								; to ensure it has some interesting non-blank data
			exx
			add hl,de			; increase vpos by vstepx
			ld b,a				; combine hi bytes of upos and vpos into a lookup address
			ld c,h
			ld a,(bc)			; read texture byte from ROM
			and %01011011		; strip flash and green out of colour byte
			ld (ix),a			; write to screen
			inc ix				; next screen byte
			exx
			djnz row			; proceed to next cell in row

			exx
			pop hl
vstepy		ld de,0x0030		; amount y coord of texture should change
								; for one step in the y direction on screen
			add hl,de
			exx
			pop hl
ustepy		ld de,0xfff3		; amount x coord of texture should change
								; for one step in the y direction on screen
			add hl,de

			dec c
			jr nz,scrn			; proceed to next line of screen

; move texture
;			pop hl
;			ld de,0x0022
;			add hl,de
;			ld (vpos + 1),hl

			ld a,(skew+1)
			cp 64
			jr z,no_skew
			add a,2
			ld (skew+1),a
no_skew

; rotate texture
rota		ld hl,sine
			inc l
			inc l
			ld (rota+1),hl
			sub l			; subtract skew, so ustepx and vstepy stay continuous
			neg
			ld l,a
			call rse
			ld (ustepy+1),bc
			call arse
			ld (ustepx+1),bc
			ld (vstepy+1),bc
			call arse
			ld (vstepx+1),bc
						
			jp main_lp

; subroutine for rotation - add skew amount, read byte, and signextend
arse	; it stands for Add, Read and SignExtend. What were you thinking?
			ld a,l
skew		add a,48
			ld l,a
rse
			ld a,(hl)
			ld c,a
			sla a
			sbc a,a
			ld b,a
			ret

ay_vals		; from 13 to 1
			; these are the initial values we wanted, but the
			; code is too long, so the
			; basstones table overwrites some of them. Oh well, what we
			; end up with still sounds vaguely good.
			db 0x0c		; envelope shape
			db 0x00		; envelope speed coarse
			db 0x3c		; envelope speed fine
			db 0x00		; volume C
			db 0x0f		; volume B
			db 0x10		; volume A
			db %00111110	; mixer
			db 0x08		; noise freq
			db 0x00
			db 0x00		; pitch C
			db 0x00
;			db 0x00		; pitch B
;			db 0x03		; pitch A

			org 0x80f8
basstones
			; reverse order
			db 0x37, 0x37, 0x3c, 0x3c, 0x3c, 0x22, 0x3c, 0x3c
;			db 0x3c, 0x3c, 0x22, 0x3c, 0x3c, 0x3c, 0x37, 0x37
			
sine		equ 0xc000		; sine table generated here
