import pygame
import glob
from pygame.locals import *
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
#import readmarkers
from time import sleep
    
from effects import *
import fmod


# try importing psyco, this gives a slight performance boost
try:
    import psyco
    psyco.full()
except:
    print "[warning]: no psyco; install psyco for a slight performance boost"

g_screensize = (800, 600)


#setup fmod
audiosystem = fmod.System()
fft = fmod.FFT()

# setup screen
passed, failed = pygame.init()

if failed:
    print "[error]: pygame init failed"

screen = pygame.display.set_mode(g_screensize, OPENGL | DOUBLEBUF)

pygame.display.set_caption("eenakter")

if screen is None:
    print "[error]: couldn't create opengl display"



#markers = readmarkers.readmarkers("data/useful/markers.txt")


#########################################################################



imgfiles = glob.glob("sized*.jpg")
images = []



for i in  imgfiles:
    image = Image(i, .6, .3, 0, 0)
    images.append(image)

g = Gradient()

# construct effects
#testImage = Image("aap.jpg", 0.5,0.5 , 0, 0, 0,1,10,11)

schedule = []
idx = 0
length = 2

totaltime = (len(imgfiles)) * length

for i in images:
    
    schedule.append( [idx*length, (idx+1)* length, [ i]])
    idx += 1


spectrum = Spectrum()
schedule.append( [0, 300 , [spectrum]])

# this is where we define the effect order
#schedule = [ (0, 60, [ g, testImage])

#           ]


#########################################################################

# this renders a schedule
def renderSchedule(schedule, time, delta):
    for job in schedule:
        if job[0] <= time < job[1] :
            for effect in job[2]:
                effect.setFFT(fft)
                effect.draw(time, 0, job[0], job[1])    


tune = audiosystem.createStream("neuk.mp3")
tune.play()

lastTime = -1
               
running = True
### demoloop
while running:
    sleep(.1)
    time =  tune.getTime()
    if time > totaltime:
        running = False
    
    if lastTime == -1:
        lastTime = time


    fft.updateSpectrum(time - lastTime)
    events = pygame.event.get()
    for event in events:
        if event.type==QUIT:
            running = False
        if event.type==KEYDOWN:
            if event.key == K_s:
                spectrum.visible = (~spectrum.visible)

#            if event.key == K_UP:
#                t = readmarkers.getnext(markers,time)
#                if t != None:
#                    tune.seek(t)

#            if event.key == K_DOWN:
#                t = readmarkers.getprevious(markers,time)
#                if t != None:
#                    tune.seek(t)

                
            if event.key == K_RIGHT:
                tune.seek(time + 5)
            if event.key == K_LEFT:
                tune.seek(time - 5)
            if event.key == K_ESCAPE or event.key == K_q:
                running = False
                



    glClearColor(0, 0, 0, 0)
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    renderSchedule(schedule, time, time-lastTime)
    pygame.display.flip()

    lastTime = time

    timeStr = `time`.split(".")
    marker = "none"
#    marker = readmarkers.getclosest(markers,time)


    
    pygame.display.set_caption("eenakter "+ timeStr[0] + "." + timeStr[1][:3] + ": [" + marker+"]")

tune.stop()
