#include <fmod.h>
#include <fmod_errors.h>
#include <stdio.h>
#include <iostream>

#include <boost/shared_ptr.hpp>
#include <boost/python.hpp>
#include <map>
#include <list>
#include <algorithm>
#include <vector>

using namespace boost;
void doeniets(FSOUND_STREAM* aap);

// void ERRCHECK(FMOD_RESULT result);

class fmodSystem;


class fmodFFT {

 protected:
  std::vector<float> m_spectrum;
  std::vector<float> m_spectrumSmooth;
  float m_lastTime;

 public:
  
  fmodFFT() {
    m_spectrum.resize(512);
    m_spectrumSmooth.resize(512);
    m_lastTime = -1;

    for (int i =0; i< 512;++i) {
      m_spectrumSmooth[i] = 0;
      m_spectrum[i] = 0;
    }
    
  }
  ~fmodFFT() {

  }

  


  void updateSpectrum(float delta) {

    const float* spectrum = FSOUND_DSP_GetSpectrum();
    for (int i = 0 ; i <512; ++i) {
      m_spectrum[i] = spectrum[i];
    }

    for (int i = 0 ; i <512; ++i) {
      if (delta > 1) 
        delta = 1;
      if (delta < 0)
        delta = 1;

      m_spectrumSmooth[i] = (m_spectrumSmooth[i] * 1.0 - delta) + spectrum[i] * delta;
    }

    
  }


  float getSmoothSpectralDensity(int start, int end) {

    if (start < 0)
      start = 0;

    if (end > 512)
      end = 512;

    float sum  = 0;
    for (int i = start; i < end; ++i) {
      sum += m_spectrumSmooth[i];
    }
    return sum;

  }



  //  std::vector<float> getSpectrum();
  float getSpectralDensity(int start, int end) {

    if (start < 0)
      start = 0;

    if (end > 512)
      end = 512;

    float sum  = 0;
    for (int i = start; i < end; ++i) {
      sum += m_spectrum[i];
    }
    return sum;

  }


};

class fmodStream {
 public:  // 
  shared_ptr<FSOUND_STREAM> sound;
 public:
  fmodStream() { printf("fmodStream()\n"); };
  fmodStream( 
            shared_ptr<FSOUND_STREAM> sound ) : 
    sound(sound) 
    { 
      printf("fmodStream(a);\n"); 
    };
  
  ~fmodStream() 
    {     
      stop();
      printf("~fmodStream()\n");
    }
  
  void play();
  void stop();
  float getTime();
  float getLength();
  void seek(float offset);
    
};


class fmodSound {
 public:  // fuck private
  shared_ptr<FMUSIC_MODULE> sound;
  static std::map< FMUSIC_MODULE*, boost::python::object> callbackmap;
  static std::list< std::pair< FMUSIC_MODULE*, unsigned char > > eventlist;
  //  static boost::python::object TEHCALBAK;
 public:
  fmodSound() { printf("fmodSound()\n"); };
  fmodSound( 
            shared_ptr<FMUSIC_MODULE> sound ) : 
    sound(sound) 
    { 
      printf("fmodSound(a);\n"); 
    };
  
  ~fmodSound() 
    {     
      stop();
      printf("~fmodSound()\n");
    }
  
  void play();
  void stop();
  int getOrder();
  int getMaxOrder();
  void setOrder( int o );
  void setInstCallback( boost::python::object o )
    {
      printf("setinstcallback\n"); 
      callbackmap[sound.get()] = o;
    };
  static void F_CALLBACKAPI instCallback(FMUSIC_MODULE *mod,
                                unsigned char param) 
    {
      eventlist.push_back( std::pair< FMUSIC_MODULE*, unsigned char >( mod, param ) );
    }

  //  void instcallback
};




class fmodSystem {
 public:
  void update()
    {
      // printf("update()\n");
      FSOUND_Update();
      while (!fmodSound::eventlist.empty())
        {
          std::pair< FMUSIC_MODULE*, unsigned char > p = fmodSound::eventlist.front();
          fmodSound::eventlist.pop_front();
          // printf("got event from list.. calling\n");
          if (fmodSound::callbackmap.find( p.first ) != fmodSound::callbackmap.end())
            {
              // printf( "found entry in callbackmap!\n");
              fmodSound::callbackmap[p.first](p.second);
            }
        }
      //      system->update();
    }
  unsigned int      version;
  fmodSystem()
    {
      if (FSOUND_GetVersion() < FMOD_VERSION) {
        
        printf("Error : You are using the wrong DLL version!  You should be using FMOD %.02f\n", FMOD_VERSION);
        exit(1);
      }
      
      if (!FSOUND_Init(32000, 64, 1)) {
        printf("%s\n", FMOD_ErrorString(FSOUND_GetError()));
        exit(1);
      }
     
      DLL_API FSOUND_DSPUNIT *fft = FSOUND_DSP_GetFFTUnit();

      // enable the fft unit 
      FSOUND_DSP_SetActive(fft,true);

 
      printf("fmodsystem()\n");
    }



  fmodStream createStream(std::string filename) {
    FSOUND_STREAM *stream;
    stream = FSOUND_Stream_Open(filename.c_str(), FSOUND_NORMAL | FSOUND_MPEGACCURATE, 0, 0); 
    return fmodStream(shared_ptr< FSOUND_STREAM >(stream, doeniets));
  }

  fmodSound createSound( std::string filename )
    {
      FMUSIC_MODULE * mod;
      //      shared_ptr< FMUSIC_MODULE > mod;
      
      mod = (FMUSIC_LoadSong(filename.c_str()));
      if (!mod) {
        printf("error in createsound(%s): %s\n", filename.c_str(), FMOD_ErrorString(FSOUND_GetError()));
        exit(1);
      }

      return fmodSound( shared_ptr< FMUSIC_MODULE >(mod, FMUSIC_FreeSong));
    }
};

/*
void orig(){

  FMUSIC_MODULE *mod = NULL;
  
  mod = FMUSIC_LoadSong("bp_demo_boemtjak.xm");
  if (!mod) {
    printf("%s\n", FMOD_ErrorString(FSOUND_GetError()));
    exit(1);
  }
  FMUSIC_PlaySong(mod);     

  for (int i = 0;i <30;++i)
    FMUSIC_SetInstCallback(mod, 
                           instCallback,
                           i);


    int pattern = FMUSIC_GetOrder(mod);
    int row = FMUSIC_GetRow(mod);

}
*/
